# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_multi_disk.py'
# DO NOT CHANGE! Change the original file instead.
import json
from collections.abc import Generator
from pathlib import Path
from typing import TYPE_CHECKING

import pytest
from dirty_equals import IsDatetime
from inline_snapshot import snapshot
from typing_extensions import override

from key_value.sync.code_gen.stores.disk.multi_store import MultiDiskStore
from tests.code_gen.stores.base import BaseStoreTests, ContextManagerStoreTestMixin

if TYPE_CHECKING:
    from diskcache.core import Cache

TEST_SIZE_LIMIT = 100 * 1024  # 100KB


class TestMultiDiskStore(ContextManagerStoreTestMixin, BaseStoreTests):
    @override
    @pytest.fixture
    def store(self, per_test_temp_dir: Path) -> Generator[MultiDiskStore, None, None]:
        store = MultiDiskStore(base_directory=per_test_temp_dir, max_size=TEST_SIZE_LIMIT)

        yield store

        # Wipe the store after returning it
        for collection in store._cache:  # pyright: ignore[reportPrivateUsage]
            store._cache[collection].clear()  # pyright: ignore[reportPrivateUsage]

    def test_value_stored(self, store: MultiDiskStore):
        store.put(collection="test", key="test_key", value={"name": "Alice", "age": 30})
        disk_cache: Cache = store._cache["test"]  # pyright: ignore[reportPrivateUsage]

        value = disk_cache.get(key="test_key")
        value_as_dict = json.loads(value)
        assert value_as_dict == snapshot(
            {
                "collection": "test",
                "value": {"name": "Alice", "age": 30},
                "key": "test_key",
                "created_at": IsDatetime(iso_string=True),
                "version": 1,
            }
        )

        store.put(collection="test", key="test_key", value={"name": "Alice", "age": 30}, ttl=10)

        value = disk_cache.get(key="test_key")
        value_as_dict = json.loads(value)
        assert value_as_dict == snapshot(
            {
                "collection": "test",
                "created_at": IsDatetime(iso_string=True),
                "value": {"age": 30, "name": "Alice"},
                "key": "test_key",
                "expires_at": IsDatetime(iso_string=True),
                "version": 1,
            }
        )
