% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-set.R
\name{intersect.dtplyr_step}
\alias{intersect.dtplyr_step}
\alias{union.dtplyr_step}
\alias{union_all.dtplyr_step}
\alias{setdiff.dtplyr_step}
\title{Set operations}
\usage{
\method{intersect}{dtplyr_step}(x, y, ...)

\method{union}{dtplyr_step}(x, y, ...)

\method{union_all}{dtplyr_step}(x, y, ...)

\method{setdiff}{dtplyr_step}(x, y, ...)
}
\arguments{
\item{x, y}{A pair of \code{\link[=lazy_dt]{lazy_dt()}}s.}

\item{...}{Ignored}
}
\description{
These are methods for the dplyr generics \code{\link[generics:setops]{generics::intersect()}},
\code{\link[generics:setops]{generics::union()}}, \code{\link[dplyr:setops]{dplyr::union_all()}}, and \code{\link[generics:setops]{generics::setdiff()}}. They are
translated to \code{\link[data.table:setops]{data.table::fintersect()}}, \code{\link[data.table:setops]{data.table::funion()}}, and
\code{\link[data.table:setops]{data.table::fsetdiff()}}.
}
\examples{
dt1 <- lazy_dt(data.frame(x = 1:4))
dt2 <- lazy_dt(data.frame(x = c(2, 4, 6)))

intersect(dt1, dt2)
union(dt1, dt2)
setdiff(dt1, dt2)

}
