package build

import (
	"github.com/slimtoolkit/slim/pkg/app/master/command"

	"github.com/c-bata/go-prompt"
)

var CommandSuggestion = prompt.Suggest{
	Text:        Name,
	Description: Usage,
}

var CommandFlagSuggestions = &command.FlagSuggestions{
	Names: []prompt.Suggest{
		{Text: command.FullFlagName(command.FlagCommandParamsFile), Description: command.FlagCommandParamsFileUsage},
		{Text: command.FullFlagName(command.FlagTarget), Description: command.FlagTargetUsage},
		{Text: command.FullFlagName(command.FlagComposeFile), Description: command.FlagComposeFileUsage},
		{Text: command.FullFlagName(command.FlagTargetComposeSvc), Description: command.FlagTargetComposeSvcUsage},
		{Text: command.FullFlagName(command.FlagTargetComposeSvcImage), Description: command.FlagTargetComposeSvcImageUsage},
		{Text: command.FullFlagName(command.FlagComposeSvcStartWait), Description: command.FlagComposeSvcStartWaitUsage},
		{Text: command.FullFlagName(command.FlagDepIncludeComposeSvc), Description: command.FlagDepIncludeComposeSvcUsage},
		{Text: command.FullFlagName(command.FlagDepExcludeComposeSvc), Description: command.FlagDepExcludeComposeSvcUsage},
		{Text: command.FullFlagName(command.FlagDepIncludeComposeSvcDeps), Description: command.FlagDepIncludeComposeSvcDepsUsage},
		{Text: command.FullFlagName(command.FlagComposeNet), Description: command.FlagComposeNetUsage},
		{Text: command.FullFlagName(command.FlagDepIncludeTargetComposeSvcDeps), Description: command.FlagDepIncludeTargetComposeSvcDepsUsage},
		{Text: command.FullFlagName(command.FlagComposeEnvNoHost), Description: command.FlagComposeEnvNoHostUsage},
		{Text: command.FullFlagName(command.FlagComposeEnvFile), Description: command.FlagComposeEnvFileUsage},
		{Text: command.FullFlagName(command.FlagComposeProjectName), Description: command.FlagComposeProjectNameUsage},
		{Text: command.FullFlagName(command.FlagComposeWorkdir), Description: command.FlagComposeWorkdirUsage},
		{Text: command.FullFlagName(command.FlagContainerProbeComposeSvc), Description: command.FlagContainerProbeComposeSvcUsage},
		{Text: command.FullFlagName(command.FlagTargetKubeWorkload), Description: command.FlagTargetKubeWorkloadUsage},
		{Text: command.FullFlagName(command.FlagTargetKubeWorkloadNamespace), Description: command.FlagTargetKubeWorkloadNamespaceUsage},
		{Text: command.FullFlagName(command.FlagTargetKubeWorkloadContainer), Description: command.FlagTargetKubeWorkloadContainerUsage},
		{Text: command.FullFlagName(command.FlagTargetKubeWorkloadImage), Description: command.FlagTargetKubeWorkloadImageUsage},
		{Text: command.FullFlagName(command.FlagKubeManifestFile), Description: command.FlagKubeManifestFileUsage},
		{Text: command.FullFlagName(command.FlagKubeKubeconfigFile), Description: command.FlagKubeKubeconfigFileUsage},
		{Text: command.FullFlagName(command.FlagPull), Description: command.FlagPullUsage},
		{Text: command.FullFlagName(command.FlagShowPullLogs), Description: command.FlagShowPullLogsUsage},
		{Text: command.FullFlagName(command.FlagRegistryAccount), Description: command.FlagRegistryAccountUsage},
		{Text: command.FullFlagName(command.FlagRegistrySecret), Description: command.FlagRegistrySecretUsage},
		{Text: command.FullFlagName(command.FlagDockerConfigPath), Description: command.FlagDockerConfigPathUsage},
		{Text: command.FullFlagName(FlagShowBuildLogs), Description: FlagShowBuildLogsUsage},
		{Text: command.FullFlagName(command.FlagShowContainerLogs), Description: command.FlagShowContainerLogsUsage},
		{Text: command.FullFlagName(command.FlagEnableMondelLogs), Description: command.FlagEnableMondelLogsUsage},
		{Text: command.FullFlagName(command.FlagCRORuntime), Description: command.FlagCRORuntimeUsage},
		{Text: command.FullFlagName(command.FlagCROHostConfigFile), Description: command.FlagCROHostConfigFileUsage},
		{Text: command.FullFlagName(command.FlagCROSysctl), Description: command.FlagCROSysctlUsage},
		{Text: command.FullFlagName(command.FlagCROShmSize), Description: command.FlagCROShmSizeUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeOff), Description: command.FlagHTTPProbeOffUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbe), Description: command.FlagHTTPProbeUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeCmd), Description: command.FlagHTTPProbeCmdUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeCmdFile), Description: command.FlagHTTPProbeCmdFileUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeStartWait), Description: command.FlagHTTPProbeStartWaitUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeRetryCount), Description: command.FlagHTTPProbeRetryCountUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeRetryWait), Description: command.FlagHTTPProbeRetryWaitUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbePorts), Description: command.FlagHTTPProbePortsUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeFull), Description: command.FlagHTTPProbeFullUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeExitOnFailure), Description: command.FlagHTTPProbeExitOnFailureUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeCrawl), Description: command.FlagHTTPProbeCrawlUsage},
		{Text: command.FullFlagName(command.FlagHTTPCrawlMaxDepth), Description: command.FlagHTTPCrawlMaxDepthUsage},
		{Text: command.FullFlagName(command.FlagHTTPCrawlMaxPageCount), Description: command.FlagHTTPCrawlMaxPageCountUsage},
		{Text: command.FullFlagName(command.FlagHTTPCrawlConcurrency), Description: command.FlagHTTPCrawlConcurrencyUsage},
		{Text: command.FullFlagName(command.FlagHTTPMaxConcurrentCrawlers), Description: command.FlagHTTPMaxConcurrentCrawlersUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeAPISpec), Description: command.FlagHTTPProbeAPISpecUsage},
		{Text: command.FullFlagName(command.FlagHTTPProbeAPISpecFile), Description: command.FlagHTTPProbeAPISpecFileUsage},
		{Text: command.FullFlagName(command.FlagPublishPort), Description: command.FlagPublishPortUsage},
		{Text: command.FullFlagName(command.FlagPublishExposedPorts), Description: command.FlagPublishExposedPortsUsage},
		{Text: command.FullFlagName(command.FlagHostExec), Description: command.FlagHostExecUsage},
		{Text: command.FullFlagName(command.FlagHostExecFile), Description: command.FlagHostExecFileUsage},
		{Text: command.FullFlagName(FlagKeepPerms), Description: FlagKeepPermsUsage},
		{Text: command.FullFlagName(command.FlagRunTargetAsUser), Description: command.FlagRunTargetAsUserUsage},
		{Text: command.FullFlagName(command.FlagCopyMetaArtifacts), Description: command.FlagCopyMetaArtifactsUsage},
		{Text: command.FullFlagName(command.FlagRemoveFileArtifacts), Description: command.FlagRemoveFileArtifactsUsage},
		{Text: command.FullFlagName(FlagTag), Description: FlagTagUsage},
		{Text: command.FullFlagName(FlagImageOverrides), Description: FlagImageOverridesUsage},
		{Text: command.FullFlagName(command.FlagUser), Description: command.FlagUserUsage},
		{Text: command.FullFlagName(command.FlagEntrypoint), Description: command.FlagEntrypointUsage},
		{Text: command.FullFlagName(command.FlagCmd), Description: command.FlagCmdUsage},
		{Text: command.FullFlagName(command.FlagWorkdir), Description: command.FlagWorkdirUsage},
		{Text: command.FullFlagName(command.FlagEnv), Description: command.FlagEnvUsage},
		{Text: command.FullFlagName(command.FlagEnvFile), Description: command.FlagEnvFileUsage},
		{Text: command.FullFlagName(command.FlagLabel), Description: command.FlagLabelUsage},
		{Text: command.FullFlagName(command.FlagVolume), Description: command.FlagVolumeUsage},
		{Text: command.FullFlagName(command.FlagLink), Description: command.FlagLinkUsage},
		{Text: command.FullFlagName(command.FlagEtcHostsMap), Description: command.FlagEtcHostsMapUsage},
		{Text: command.FullFlagName(command.FlagContainerDNS), Description: command.FlagContainerDNSUsage},
		{Text: command.FullFlagName(command.FlagContainerDNSSearch), Description: command.FlagContainerDNSSearchUsage},
		{Text: command.FullFlagName(command.FlagNetwork), Description: command.FlagNetworkUsage},
		{Text: command.FullFlagName(command.FlagHostname), Description: command.FlagHostnameUsage},
		{Text: command.FullFlagName(command.FlagExpose), Description: command.FlagExposeUsage},
		{Text: command.FullFlagName(FlagNewEntrypoint), Description: FlagNewEntrypointUsage},
		{Text: command.FullFlagName(FlagNewCmd), Description: FlagNewCmdUsage},
		{Text: command.FullFlagName(FlagNewExpose), Description: FlagNewExposeUsage},
		{Text: command.FullFlagName(FlagNewWorkdir), Description: FlagNewWorkdirUsage},
		{Text: command.FullFlagName(FlagNewEnv), Description: FlagNewEnvUsage},
		{Text: command.FullFlagName(FlagNewVolume), Description: FlagNewVolumeUsage},
		{Text: command.FullFlagName(FlagNewLabel), Description: FlagNewLabelUsage},
		{Text: command.FullFlagName(FlagRemoveExpose), Description: FlagRemoveExposeUsage},
		{Text: command.FullFlagName(FlagRemoveEnv), Description: FlagRemoveEnvUsage},
		{Text: command.FullFlagName(FlagRemoveLabel), Description: FlagRemoveLabelUsage},
		{Text: command.FullFlagName(FlagRemoveVolume), Description: FlagRemoveVolumeUsage},
		{Text: command.FullFlagName(FlagExcludeMounts), Description: FlagExcludeMountsUsage},
		{Text: command.FullFlagName(FlagExcludeVarLockFiles), Description: FlagExcludeVarLockFilesUsage},
		{Text: command.FullFlagName(FlagExcludePattern), Description: FlagExcludePatternUsage},
		{Text: command.FullFlagName(FlagPathPerms), Description: FlagPathPermsUsage},
		{Text: command.FullFlagName(FlagPathPermsFile), Description: FlagPathPermsFileUsage},
		{Text: command.FullFlagName(FlagPreservePath), Description: FlagPreservePathUsage},
		{Text: command.FullFlagName(FlagPreservePathFile), Description: FlagPreservePathFileUsage},
		{Text: command.FullFlagName(FlagIncludePath), Description: FlagIncludePathUsage},
		{Text: command.FullFlagName(FlagIncludePathFile), Description: FlagIncludePathFileUsage},
		{Text: command.FullFlagName(FlagIncludeBin), Description: FlagIncludeBinUsage},
		{Text: command.FullFlagName(FlagIncludeBinFile), Description: FlagIncludeBinFileUsage},
		{Text: command.FullFlagName(FlagIncludeExe), Description: FlagIncludeExeUsage},
		{Text: command.FullFlagName(FlagIncludeExeFile), Description: FlagIncludeExeFileUsage},
		{Text: command.FullFlagName(FlagIncludeShell), Description: FlagIncludeShellUsage},
		{Text: command.FullFlagName(FlagIncludeWorkdir), Description: FlagIncludeWorkdirUsage},
		{Text: command.FullFlagName(FlagIncludeAppImageAll), Description: FlagIncludeAppImageAllUsage},
		{Text: command.FullFlagName(FlagAppImageStartInstGroup), Description: FlagAppImageStartInstGroupUsage},
		{Text: command.FullFlagName(FlagAppImageStartInst), Description: FlagAppImageStartInstUsage},
		{Text: command.FullFlagName(FlagAppImageDockerfile), Description: FlagAppImageDockerfileUsage},
		{Text: command.FullFlagName(FlagIncludePathsCreportFile), Description: FlagIncludePathsCreportFileUsage},
		{Text: command.FullFlagName(FlagIncludeSSHClient), Description: FlagIncludeSSHClientUsage},
		{Text: command.FullFlagName(FlagIncludeOSLibsNet), Description: FlagIncludeOSLibsNetUsage},
		{Text: command.FullFlagName(FlagIncludeCertAll), Description: FlagIncludeCertAllUsage},
		{Text: command.FullFlagName(FlagIncludeCertBundles), Description: FlagIncludeCertBundlesUsage},
		{Text: command.FullFlagName(FlagIncludeCertDirs), Description: FlagIncludeCertDirsUsage},
		{Text: command.FullFlagName(FlagIncludeCertPKAll), Description: FlagIncludeCertPKAllUsage},
		{Text: command.FullFlagName(FlagIncludeCertPKDirs), Description: FlagIncludeCertPKDirsUsage},
		{Text: command.FullFlagName(FlagIncludeNew), Description: FlagIncludeNewUsage},
		{Text: command.FullFlagName(command.FlagMount), Description: command.FlagMountUsage},
		{Text: command.FullFlagName(command.FlagContinueAfter), Description: command.FlagContinueAfterUsage},
		{Text: command.FullFlagName(command.FlagUseLocalMounts), Description: command.FlagUseLocalMountsUsage},
		{Text: command.FullFlagName(command.FlagUseSensorVolume), Description: command.FlagUseSensorVolumeUsage},
		{Text: command.FullFlagName(FlagKeepTmpArtifacts), Description: FlagKeepTmpArtifactsUsage},
		{Text: command.FullFlagName(FlagIncludeAppNuxtDir), Description: FlagIncludeAppNuxtDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNuxtBuildDir), Description: FlagIncludeAppNuxtBuildDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNuxtDistDir), Description: FlagIncludeAppNuxtDistDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNuxtStaticDir), Description: FlagIncludeAppNuxtStaticDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNuxtNodeModulesDir), Description: FlagIncludeAppNuxtNodeModulesDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNextDir), Description: FlagIncludeAppNextDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNextBuildDir), Description: FlagIncludeAppNextBuildDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNextDistDir), Description: FlagIncludeAppNextDistDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNextStaticDir), Description: FlagIncludeAppNextStaticDirUsage},
		{Text: command.FullFlagName(FlagIncludeAppNextNodeModulesDir), Description: FlagIncludeAppNextNodeModulesDirUsage},
		{Text: command.FullFlagName(FlagIncludeNodePackage), Description: FlagIncludeNodePackageUsage},
		{Text: command.FullFlagName(FlagBuildFromDockerfile), Description: FlagBuildFromDockerfileUsage},
		{Text: command.FullFlagName(FlagDockerfileContext), Description: FlagDockerfileContextUsage},
		{Text: command.FullFlagName(FlagTagFat), Description: FlagTagFatUsage},
		{Text: command.FullFlagName(FlagCBOAddHost), Description: FlagCBOAddHostUsage},
		{Text: command.FullFlagName(FlagCBOBuildArg), Description: FlagCBOBuildArgUsage},
		{Text: command.FullFlagName(FlagCBOLabel), Description: FlagCBOLabelUsage},
		{Text: command.FullFlagName(FlagCBOTarget), Description: FlagCBOTargetUsage},
		{Text: command.FullFlagName(FlagCBONetwork), Description: FlagCBONetworkUsage},
		{Text: command.FullFlagName(FlagCBOCacheFrom), Description: FlagCBOCacheFromUsage},
		{Text: command.FullFlagName(command.FlagDeleteFatImage), Description: command.FlagDeleteFatImageUsage},
		{Text: command.FullFlagName(command.FlagRTAOnbuildBaseImage), Description: command.FlagRTAOnbuildBaseImageUsage},
		{Text: command.FullFlagName(command.FlagRTASourcePT), Description: command.FlagRTASourcePTUsage},
		{Text: command.FullFlagName(command.FlagSensorIPCMode), Description: command.FlagSensorIPCModeUsage},
		{Text: command.FullFlagName(command.FlagSensorIPCEndpoint), Description: command.FlagSensorIPCEndpointUsage},
		{Text: command.FullFlagName(FlagImageBuildEngine), Description: FlagImageBuildEngineUsage},
		{Text: command.FullFlagName(FlagImageBuildArch), Description: FlagImageBuildArchUsage},
		{Text: command.FullFlagName(FlagObfuscateMetadata), Description: FlagObfuscateMetadataUsage},
	},
	Values: map[string]command.CompleteValue{
		command.FullFlagName(command.FlagCommandParamsFile): command.CompleteFile,
		//NOTE: with FlagPull target complete needs to check remote registries too
		command.FullFlagName(command.FlagPull):                           command.CompleteTBool,
		command.FullFlagName(command.FlagShowPullLogs):                   command.CompleteBool,
		command.FullFlagName(command.FlagDockerConfigPath):               command.CompleteFile,
		command.FullFlagName(command.FlagTarget):                         command.CompleteImage,
		command.FullFlagName(command.FlagComposeFile):                    command.CompleteFile,
		command.FullFlagName(command.FlagDepIncludeTargetComposeSvcDeps): command.CompleteBool,
		command.FullFlagName(command.FlagComposeEnvNoHost):               command.CompleteBool,
		command.FullFlagName(command.FlagComposeEnvFile):                 command.CompleteFile,
		command.FullFlagName(command.FlagComposeWorkdir):                 command.CompleteFile,
		command.FullFlagName(command.FlagKubeManifestFile):               command.CompleteFile,
		command.FullFlagName(command.FlagKubeKubeconfigFile):             command.CompleteFile,
		command.FullFlagName(FlagShowBuildLogs):                          command.CompleteBool,
		command.FullFlagName(command.FlagShowContainerLogs):              command.CompleteBool,
		command.FullFlagName(command.FlagEnableMondelLogs):               command.CompleteBool,
		command.FullFlagName(command.FlagPublishExposedPorts):            command.CompleteBool,
		command.FullFlagName(command.FlagHTTPProbeOff):                   command.CompleteBool,
		command.FullFlagName(command.FlagHTTPProbe):                      command.CompleteTBool,
		command.FullFlagName(command.FlagHTTPProbeCmdFile):               command.CompleteFile,
		command.FullFlagName(command.FlagHTTPProbeFull):                  command.CompleteBool,
		command.FullFlagName(command.FlagHTTPProbeExitOnFailure):         command.CompleteBool,
		command.FullFlagName(command.FlagHTTPProbeCrawl):                 command.CompleteTBool,
		command.FullFlagName(command.FlagHTTPProbeAPISpecFile):           command.CompleteFile,
		command.FullFlagName(command.FlagHostExecFile):                   command.CompleteFile,
		command.FullFlagName(FlagKeepPerms):                              command.CompleteTBool,
		command.FullFlagName(command.FlagRunTargetAsUser):                command.CompleteTBool,
		command.FullFlagName(command.FlagRemoveFileArtifacts):            command.CompleteBool,
		command.FullFlagName(command.FlagNetwork):                        command.CompleteNetwork,
		command.FullFlagName(FlagExcludeVarLockFiles):                    command.CompleteTBool,
		command.FullFlagName(FlagExcludeMounts):                          command.CompleteTBool,
		command.FullFlagName(FlagPathPermsFile):                          command.CompleteFile,
		command.FullFlagName(FlagPreservePathFile):                       command.CompleteFile,
		command.FullFlagName(FlagIncludePathFile):                        command.CompleteFile,
		command.FullFlagName(FlagIncludeBinFile):                         command.CompleteFile,
		command.FullFlagName(FlagIncludeExeFile):                         command.CompleteFile,
		command.FullFlagName(FlagIncludePathsCreportFile):                command.CompleteFile,
		command.FullFlagName(FlagIncludeShell):                           command.CompleteBool,
		command.FullFlagName(FlagIncludeWorkdir):                         command.CompleteBool,
		command.FullFlagName(FlagIncludeAppImageAll):                     command.CompleteBool,
		command.FullFlagName(FlagIncludeSSHClient):                       command.CompleteBool,
		command.FullFlagName(FlagIncludeOSLibsNet):                       command.CompleteBool,
		command.FullFlagName(FlagIncludeCertAll):                         command.CompleteBool,
		command.FullFlagName(FlagIncludeCertBundles):                     command.CompleteBool,
		command.FullFlagName(FlagIncludeCertDirs):                        command.CompleteBool,
		command.FullFlagName(FlagIncludeCertPKAll):                       command.CompleteBool,
		command.FullFlagName(FlagIncludeCertPKDirs):                      command.CompleteBool,
		command.FullFlagName(FlagIncludeNew):                             command.CompleteBool,
		command.FullFlagName(command.FlagContinueAfter):                  command.CompleteContinueAfter,
		//command.FullFlagName(command.FlagConsoleFormat):                  command.CompleteConsoleOutput,
		command.FullFlagName(command.FlagUseLocalMounts):       command.CompleteBool,
		command.FullFlagName(command.FlagUseSensorVolume):      command.CompleteVolume,
		command.FullFlagName(FlagKeepTmpArtifacts):             command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNuxtDir):            command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNuxtBuildDir):       command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNuxtDistDir):        command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNuxtStaticDir):      command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNuxtNodeModulesDir): command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNextDir):            command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNextBuildDir):       command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNextDistDir):        command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNextStaticDir):      command.CompleteBool,
		command.FullFlagName(FlagIncludeAppNextNodeModulesDir): command.CompleteBool,
		command.FullFlagName(command.FlagCROHostConfigFile):    command.CompleteFile,
		command.FullFlagName(FlagDockerfileContext):            command.CompleteFile,
		command.FullFlagName(FlagDeleteFatImage):               command.CompleteBool,
		command.FullFlagName(command.FlagRTAOnbuildBaseImage):  command.CompleteBool,
		command.FullFlagName(command.FlagRTASourcePT):          command.CompleteBool,
		command.FullFlagName(command.FlagSensorIPCMode):        command.CompleteIPCMode,
		command.FullFlagName(FlagImageBuildEngine):             CompleteImageBuildEngine,
		command.FullFlagName(FlagImageBuildArch):               CompleteImageBuildArch,
		command.FullFlagName(FlagAppImageDockerfile):           command.CompleteFile,
		command.FullFlagName(FlagObfuscateMetadata):            command.CompleteBool,
	},
}

var imageBuildEngineValues = []prompt.Suggest{
	{Text: IBENone, Description: "no image build engine (output image is not built)"},
	{Text: IBEInternal, Description: "internal image build engine"},
	{Text: IBEDocker, Description: "standard Docker image build engine"},
	{Text: IBEBuildKit, Description: "BuildKit image build engine"},
}

func CompleteImageBuildEngine(ia *command.InteractiveApp, token string, params prompt.Document) []prompt.Suggest {
	return prompt.FilterHasPrefix(imageBuildEngineValues, token, true)
}

var imageBuildArchValues = []prompt.Suggest{
	{Text: ArchAmd64, Description: "amd64 architecture"},
	{Text: ArchArm64, Description: "arm64 architecture"},
}

func CompleteImageBuildArch(ia *command.InteractiveApp, token string, params prompt.Document) []prompt.Suggest {
	return prompt.FilterHasPrefix(imageBuildArchValues, token, true)
}
