# Contributing to Starkiller

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## Creating Github Issues

Please first review the existing Starkiller issues to see if the error was resolved with a fix in the development branch or if we chose not to fix the error for some reason.

The more information you provide in a Github issue the easier it will be for us to track down and fix the problem:

- Please provide the version of Empire you are using.
- Please provide the OS, and Starkiller version that you are using.
- Please describe the expected behavior and the encountered error.
  - The more detail the better!
  - Include any actions taken just prior to the error.
  - Please post a screenshot of the error, a link to a Pastebin dump of the error, or embedded text of the error.
  - Any additional information.

## Making a Pull Request

1. Create an issue describing the motivation for your changes

   - Pull Requests without associated Issues may still be accepted, if the motivation is obvious. However, this will help speed up code review if there's any uncertainty.

1. Fork the repo and create your branch from main.
1. Make sure your code lints.
1. Issue that pull request!

## Use a Consistent Coding Style

We use Airbnb's and Vue's recommended ESLint configs. To make your life easier, consider installing an ESLint plugin in your editor of choice. You can also run `yarn lint`.
