/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.breadcrumb;

import com.paterva.maltego.util.ui.breadcrumb.BreadCrumbBar;
import com.paterva.maltego.util.ui.breadcrumb.BreadCrumbSection;
import com.paterva.maltego.util.ui.breadcrumb.BreadCrumbSectionPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BreadCrumbBarPanel
extends JPanel {
    private final BreadCrumbBar _bar;
    private ActionListener _sectionListener;
    private BreadCrumbBarListener _barListener;

    public BreadCrumbBarPanel(BreadCrumbBar bar) {
        this.setLayout(new BoxLayout(this, 2));
        this._bar = bar;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addSections();
        this._barListener = new BreadCrumbBarListener();
        this._bar.addChangeListener(this._barListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._bar.removeChangeListener(this._barListener);
        this._barListener = null;
        this.removeSections();
    }

    public void addSections() {
        this.addAll();
        this.addSectionListeners();
    }

    public void removeSections() {
        this.removeSectionListeners();
        this.removeAll();
    }

    public void addAll() {
        int depth = 0;
        for (BreadCrumbSection section : this._bar.getSections()) {
            BreadCrumbSectionPanel sectionPanel = new BreadCrumbSectionPanel(section, depth);
            this.add(sectionPanel);
            ++depth;
        }
        this.revalidate();
        this.repaint();
    }

    private void addSectionListeners() {
        this._sectionListener = new SectionListener();
        for (Component component : this.getComponents()) {
            if (!(component instanceof BreadCrumbSectionPanel)) continue;
            BreadCrumbSectionPanel sectionPanel = (BreadCrumbSectionPanel)component;
            sectionPanel.addActionListener(this._sectionListener);
        }
    }

    private void removeSectionListeners() {
        if (this._sectionListener != null) {
            for (Component component : this.getComponents()) {
                if (!(component instanceof BreadCrumbSectionPanel)) continue;
                BreadCrumbSectionPanel sectionPanel = (BreadCrumbSectionPanel)component;
                sectionPanel.removeActionListener(this._sectionListener);
            }
            this._sectionListener = null;
        }
    }

    private class BreadCrumbBarListener
    implements ChangeListener {
        private BreadCrumbBarListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BreadCrumbBarPanel.this.removeSections();
            BreadCrumbBarPanel.this.addSections();
        }
    }

    private class SectionListener
    implements ActionListener {
        private SectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof BreadCrumbSectionPanel) {
                BreadCrumbSectionPanel sectionPanel = (BreadCrumbSectionPanel)source;
                ArrayList<BreadCrumbSection> newSections = new ArrayList<BreadCrumbSection>();
                for (BreadCrumbSection section : BreadCrumbBarPanel.this._bar.getSections()) {
                    newSections.add(section);
                    if (!section.equals(sectionPanel.getSection())) continue;
                    break;
                }
                BreadCrumbBarPanel.this._bar.setSections(newSections);
            }
        }
    }
}

