/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

public class ConstraintUtils {
    public static GridBagConstraints getConstraints(Container container, Component component) {
        GridBagLayout gbl = (GridBagLayout)container.getLayout();
        return gbl.getConstraints(component);
    }

    public static void updateContraints(Container container, Component component, GridBagConstraints constraints) {
        int componentIndex = 0;
        for (Component c : container.getComponents()) {
            if (component.equals(c)) break;
            ++componentIndex;
        }
        container.remove(component);
        container.add(component, constraints, componentIndex);
    }

    public static void setTopInset(Container container, Component component, int insetTop) {
        GridBagConstraints constraints = ConstraintUtils.getConstraints(container, component);
        if (constraints.insets.top != insetTop) {
            constraints.insets.top = insetTop;
            ConstraintUtils.updateContraints(container, component, constraints);
        }
    }

    public static void setGridHeight(Container container, Component component, int gridHeight) {
        GridBagConstraints constraints = ConstraintUtils.getConstraints(container, component);
        if (constraints.gridheight != gridHeight) {
            constraints.gridheight = gridHeight;
            ConstraintUtils.updateContraints(container, component, constraints);
        }
    }
}

