/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.impl.SelectiveGlobalActionContext;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class TopGraphPartSelectionAction
extends SystemAction {
    private final SelectiveGlobalActionContext _selectionContext = SelectiveGlobalActionContext.instance();

    public TopGraphPartSelectionAction() {
        this.onSelectionChanged();
        this._selectionContext.addChangeListener(e2 -> this.onSelectionChanged());
    }

    protected abstract void actionPerformed();

    protected GraphID getTopGraphID() {
        return this._selectionContext.getTopGraphID();
    }

    protected SelectiveGlobalActionContext getSelectionContext() {
        return this._selectionContext;
    }

    protected boolean isActionEnabled() {
        return this._selectionContext.getTopGraphID() != null && !this._selectionContext.isSelectionEmpty();
    }

    public void actionPerformed(ActionEvent ev) {
        Runnable runnable = () -> {
            this.actionPerformed();
            SwingUtilities.invokeLater(() -> {
                TopComponent topComponent = this.getTopComponent();
                if (topComponent != null) {
                    topComponent.requestActive();
                }
            });
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void onSelectionChanged() {
        this.setEnabled(this.isActionEnabled());
    }

    protected TopComponent getTopComponent() {
        return GraphEditorRegistry.getDefault().getTopmost();
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

