/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotExecuteNodeGen;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotListAndFunction;
import com.oracle.truffle.polyglot.PolyglotListFactory;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;

class PolyglotList<T>
extends AbstractList<T>
implements HostWrapper {
    final Object guestObject;
    final PolyglotLanguageContext languageContext;
    final Cache cache;

    PolyglotList(Class<T> elementClass, Type elementType, Object array, PolyglotLanguageContext languageContext) {
        this.guestObject = array;
        this.languageContext = languageContext;
        this.cache = Cache.lookup(languageContext, array.getClass(), elementClass, elementType);
    }

    @Override
    public Object getGuestObject() {
        return this.guestObject;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> List<T> create(PolyglotLanguageContext languageContext, Object array, boolean implementFunction, Class<T> elementClass, Type elementType) {
        if (implementFunction) {
            return new PolyglotListAndFunction<T>(elementClass, elementType, array, languageContext);
        }
        return new PolyglotList<T>(elementClass, elementType, array, languageContext);
    }

    @Override
    public T get(int index) {
        return (T)this.cache.get.call(this.languageContext, this.guestObject, index);
    }

    @Override
    public T set(int index, T element) {
        T prev = this.get(index);
        this.cache.set.call(this.languageContext, this.guestObject, index, element);
        return prev;
    }

    @Override
    public T remove(int index) {
        T prev = this.get(index);
        this.cache.remove.call(this.languageContext, this.guestObject, index);
        return prev;
    }

    @Override
    public int size() {
        return (Integer)this.cache.size.call(this.languageContext, this.guestObject);
    }

    @Override
    public String toString() {
        return HostWrapper.toString(this);
    }

    @Override
    public int hashCode() {
        return HostWrapper.hashCode(this.languageContext, this.guestObject);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PolyglotList) {
            return HostWrapper.equals(this.languageContext, this.guestObject, ((PolyglotList)o).guestObject);
        }
        return false;
    }

    static final class Cache {
        final Class<?> receiverClass;
        final Class<?> valueClass;
        final Type valueType;
        final CallTarget get;
        final CallTarget set;
        final CallTarget remove;
        final CallTarget size;
        final CallTarget apply;

        Cache(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            this.receiverClass = receiverClass;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.get = Cache.initializeCall(PolyglotListFactory.CacheFactory.GetNodeGen.create(this));
            this.size = Cache.initializeCall(PolyglotListFactory.CacheFactory.SizeNodeGen.create(this));
            this.set = Cache.initializeCall(PolyglotListFactory.CacheFactory.SetNodeGen.create(this));
            this.remove = Cache.initializeCall(PolyglotListFactory.CacheFactory.RemoveNodeGen.create(this));
            this.apply = Cache.initializeCall(new Apply(this));
        }

        private static CallTarget initializeCall(PolyglotListNode node) {
            return HostToGuestRootNode.createTarget(node);
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            Key cacheKey = new Key(receiverClass, valueClass, valueType);
            Cache cache = HostToGuestRootNode.lookupHostCodeCache(languageContext, cacheKey, Cache.class);
            if (cache == null) {
                cache = HostToGuestRootNode.installHostCodeCache(languageContext, cacheKey, new Cache(receiverClass, valueClass, valueType), Cache.class);
            }
            assert (cache.receiverClass == receiverClass);
            assert (cache.valueClass == valueClass);
            assert (cache.valueType == valueType);
            return cache;
        }

        private static class Apply
        extends PolyglotListNode {
            @Node.Child
            private PolyglotExecuteNode apply = PolyglotExecuteNodeGen.create();

            Apply(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, Object receiver, Object[] args) {
                return this.apply.execute(languageContext, receiver, args[2], Object.class, (Type)((Object)Object.class));
            }
        }

        static abstract class RemoveNode
        extends PolyglotListNode {
            RemoveNode(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Specialization(limit="LIMIT")
            Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached BranchProfile error) {
                Object key = args[2];
                assert (key instanceof Integer);
                int index = (Integer)key;
                try {
                    interop.removeArrayElement(receiver, index);
                }
                catch (InvalidArrayIndexException e) {
                    error.enter();
                    throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, index);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "remove");
                }
                return null;
            }
        }

        static abstract class SetNode
        extends PolyglotListNode {
            SetNode(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "set";
            }

            @Specialization(limit="LIMIT")
            Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached BranchProfile error) {
                Object key = args[2];
                assert (key instanceof Integer);
                int index = (Integer)key;
                Object value = toGuest.execute(languageContext, args[3]);
                try {
                    interop.writeArrayElement(receiver, index, value);
                }
                catch (InvalidArrayIndexException e) {
                    error.enter();
                    throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, index);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
                }
                catch (UnsupportedTypeException e) {
                    error.enter();
                    throw HostInteropErrors.invalidListValue(languageContext, receiver, this.cache.valueType, (Integer)key, value);
                }
                return null;
            }
        }

        static abstract class GetNode
        extends PolyglotListNode {
            GetNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached ToHostNode toHost, @Cached BranchProfile error) {
                Object key = args[2];
                Object result = null;
                assert (key instanceof Integer);
                int index = (Integer)key;
                try {
                    return toHost.execute(interop.readArrayElement(receiver, index), this.cache.valueClass, this.cache.valueType, languageContext, true);
                }
                catch (InvalidArrayIndexException e) {
                    error.enter();
                    throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, index);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "get()");
                }
            }

            @Override
            protected String getOperationName() {
                return "get";
            }
        }

        static abstract class SizeNode
        extends PolyglotListNode {
            SizeNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary interop) {
                try {
                    return (int)interop.getArraySize(receiver);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    return 0;
                }
            }

            @Override
            protected String getOperationName() {
                return "size";
            }
        }

        static abstract class PolyglotListNode
        extends HostToGuestRootNode {
            static final int LIMIT = 5;
            final Cache cache;

            PolyglotListNode(Cache cache) {
                this.cache = cache;
            }

            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotList<" + this.cache.receiverClass + ", " + this.cache.valueType + ">." + this.getOperationName();
            }

            protected abstract String getOperationName();
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> valueClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
                assert (receiverClass != null);
                this.receiverClass = receiverClass;
                this.valueClass = valueClass;
                this.valueType = valueType;
            }

            public int hashCode() {
                return 31 * (31 * (this.valueType == null ? 0 : this.valueType.hashCode()) + this.receiverClass.hashCode()) + this.valueClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.valueType == other.valueType && this.valueClass == other.valueClass && this.receiverClass == other.receiverClass;
            }
        }
    }
}

