/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run.v2.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphBuilder;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.BulkStatusDisplayer;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;

public class TabularTransformSearchGraphBuilderV2
extends TabularGraphBuilder {
    private final BulkStatusDisplayer status = new BulkStatusDisplayer("%d rows processed", 500L);
    private String searchText = null;

    public TabularTransformSearchGraphBuilderV2(GraphID graphID, TabularGraph tabularGraph, List<File> files, ProgressHandle handle, MaltegoEntity inputEntity) {
        super(graphID, tabularGraph, files, handle);
        Args.notNull((Object)graphID, (String)"graphID");
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        Args.notNullOrEmpty(files, (String)"files");
        Args.notNull((Object)handle, (String)"handle");
        Args.notNull((Object)inputEntity, (String)"inputEntity");
        this.searchText = inputEntity.getValueString();
        if (this.searchText != null) {
            this.searchText = this.searchText.toLowerCase();
        }
    }

    protected TabularGraphPartFactory createPartFactory() {
        return new TabularTransformPartFactory(this._types);
    }

    protected boolean processRow(TabularGraphIterator rowIterator) throws Exception {
        Args.notNull((Object)rowIterator, (String)"rowIterator");
        this.status.increment();
        return super.processRow(rowIterator);
    }

    protected void filterEntities(List<TabularGraphLightweightLink> lightLinks, List<TabularGraphLightweightEntity> lightEntities) {
        Args.notNull(lightLinks, (String)"lightLinks");
        Args.notNull(lightEntities, (String)"lightEntities");
        Iterator<TabularGraphLightweightEntity> itr = lightEntities.iterator();
        while (itr.hasNext()) {
            try {
                TabularGraphLightweightEntity entity = itr.next();
                if (this.searchMatch(entity)) continue;
                itr.remove();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected MaltegoEntity translate(TabularTranslator translator, TabularGraphLightweightEntity entity) throws TypeInstantiationException, TabularTranslator.RowImportException {
        Args.notNull((Object)translator, (String)"translator");
        Args.notNull((Object)entity, (String)"entity");
        return this.searchMatch(entity) ? super.translate(translator, entity) : null;
    }

    private boolean searchMatch(TabularGraphLightweightEntity entity) throws TabularTranslator.RowImportException, TypeInstantiationException {
        Args.notNull((Object)entity, (String)"entity");
        return this.searchMatch((TabularGraphEntityType)entity.type, entity.row);
    }

    private boolean searchMatch(TabularGraphEntityType type, List<Object> row) throws TabularTranslator.RowImportException, TypeInstantiationException {
        Args.notNull((Object)type, (String)"type");
        Args.notNull(row, (String)"row");
        for (int column : type.tabularEntity.getColumns()) {
            Object cellValue = row.get(column);
            if (cellValue == null || !cellValue.toString().toLowerCase().contains(this.searchText)) continue;
            return true;
        }
        return false;
    }

    protected Map<MaltegoLink, LinkEntityIDs> generateLinks(List<MaltegoEntity> entities) throws TabularTranslator.RowImportException {
        Args.notNull(entities, (String)"entities");
        return Collections.EMPTY_MAP;
    }

    private class TabularTransformPartFactory
    extends TabularGraphPartFactory {
        public TabularTransformPartFactory(TabularGraphTypes types) {
            super(types);
        }

        protected boolean shouldAdd(TabularGraphEntityType type, List<Object> row) throws Exception {
            Args.notNull((Object)type, (String)"type");
            Args.notNull(row, (String)"row");
            return TabularTransformSearchGraphBuilderV2.this.searchMatch(type, row);
        }

        protected boolean shouldAdd(TabularGraphLinkType type, TabularGraphLightweightLink lightLink) throws Exception {
            Args.notNull((Object)type, (String)"type");
            Args.notNull((Object)lightLink, (String)"lightLink");
            return false;
        }
    }
}

