/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.paterva.maltego.entity.manager.imex.EntityExistInfo;
import com.paterva.maltego.entity.manager.imex.SelectableEntitySpec;
import com.paterva.maltego.importexport.ConfigNode;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class EntitySpecNode
extends ConfigNode {
    public EntitySpecNode(SelectableEntitySpec entity, EntityExistInfo existInfo) {
        this(entity, new InstanceContent(), existInfo);
    }

    private EntitySpecNode(SelectableEntitySpec entity, InstanceContent content, EntityExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)entity);
        content.add((Object)this);
        String displayName = entity.getEntitySpec().getDisplayName();
        if (existInfo != null && existInfo.exist(entity.getEntitySpec())) {
            displayName = "<exist> " + displayName;
        }
        this.setDisplayName(displayName);
        this.setShortDescription(entity.getEntitySpec().getDescription());
        this.setSelectedNonRecursive(entity.isSelected());
    }

    public void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableEntitySpec entity = (SelectableEntitySpec)this.getLookup().lookup(SelectableEntitySpec.class);
            entity.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        SelectableEntitySpec entity = (SelectableEntitySpec)this.getLookup().lookup(SelectableEntitySpec.class);
        int size = 48;
        if (type == 1 || type == 3) {
            size = 16;
        } else if (type == 2 || type == 4) {
            size = 32;
        }
        Image icon = entity.getEntitySpec().getIcon(size);
        if (icon == null) {
            icon = ImageUtilities.loadImage((String)"com/paterva/maltego/entity/manager/resources/Entity.png");
        }
        return icon;
    }
}

