/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.manage;

import com.paterva.maltego.customicons.manage.IconNameController;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.EditDialogDisplayer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IconNameDisplayPanel
extends JPanel {
    private RegistryIcon _icon;
    private String _aliasName;
    private JButton _changeNameButton;
    private JLabel _label;
    private JTextField _nameTextField;
    private JButton _removeNameButton;

    public void setIcon(RegistryIcon icon, String aliasName) {
        this._icon = icon;
        this._aliasName = aliasName;
        this._label.setText(this.getLabel());
        this._removeNameButton.setVisible(this.isAlias());
        this._removeNameButton.setEnabled(this.isAlias());
        this._changeNameButton.setToolTipText(this.isAlias() ? "Rename Alias" : "Rename Icon");
        this.updateText();
    }

    public IconNameDisplayPanel() {
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._changeNameButton.setEnabled(enabled);
        this._removeNameButton.setEnabled(this.isAlias() ? enabled : false);
    }

    private String getLabel() {
        return this.isAlias() ? "Alias " : "Name";
    }

    private String getIconOrAliasName() {
        return this.isAlias() ? this._aliasName : (this._icon == null ? null : this._icon.getName());
    }

    private void updateText() {
        String name = this.getIconOrAliasName();
        this._nameTextField.setText(name != null ? name : "");
    }

    private boolean isAlias() {
        return this._aliasName != null;
    }

    private void initComponents() {
        this._label = new LabelWithBackground();
        this._nameTextField = new JTextField();
        this._changeNameButton = new JButton();
        this._removeNameButton = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._label, (String)NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._label.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 6, 6, 0);
        this.add((Component)this._label, gridBagConstraints);
        this._nameTextField.setEditable(false);
        this._nameTextField.setText(NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._nameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 6, 0);
        this.add((Component)this._nameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._changeNameButton, (String)NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._changeNameButton.text"));
        this._changeNameButton.setToolTipText(NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._changeNameButton.toolTipText"));
        this._changeNameButton.setMargin(new Insets(1, 8, 2, 8));
        this._changeNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconNameDisplayPanel.this._changeNameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 6, 6, 6);
        this.add((Component)this._changeNameButton, gridBagConstraints);
        this._removeNameButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/customicons/resources/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this._removeNameButton, (String)NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._removeNameButton.text"));
        this._removeNameButton.setToolTipText(NbBundle.getMessage(IconNameDisplayPanel.class, (String)"IconNameDisplayPanel._removeNameButton.toolTipText"));
        this._removeNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconNameDisplayPanel.this._removeNameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 6, 6);
        this.add((Component)this._removeNameButton, gridBagConstraints);
    }

    private void _changeNameButtonActionPerformed(ActionEvent evt) {
        String newName;
        IconNameController controller = new IconNameController(this.getLabel(), this.isAlias());
        EditDialogDescriptor descriptor = new EditDialogDescriptor((WizardDescriptor.Panel)controller);
        String oldName = this.getIconOrAliasName();
        descriptor.putProperty("iconCategory", (Object)this._icon.getCategory());
        descriptor.putProperty("iconName", (Object)oldName);
        if (EditDialogDescriptor.OK_OPTION.equals(EditDialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) && !oldName.equals(newName = (String)descriptor.getProperty("iconName"))) {
            try {
                if (this.isAlias()) {
                    IconRegistry registry = IconRegistry.getDefault();
                    LinkedHashSet aliases = this._icon.getAliases().stream().map(alias -> alias.equals(oldName) ? newName : alias).collect(Collectors.toCollection(LinkedHashSet::new));
                    registry.setAliases(this._icon, (Set)aliases);
                    this._aliasName = newName;
                } else {
                    this._icon = IconLayerRegistry.getDefault().rename(this._icon, newName);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.updateText();
        }
    }

    private void _removeNameButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)"Are you sure you want to remove the icon alias?", "Remove Icon Alias", 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            try {
                IconRegistry.getDefault().removeAlias(this._icon, this._aliasName);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

