/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.browser;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.browser.BrowserLoginOptionsControl;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

public class BrowserLoginOptionsController
extends ValidatingController<BrowserLoginOptionsControl> {
    public static final String USE_SYSTEM_BROWSER = "browser.login.use.system.browser";
    private ChangeListener clickListener;

    public BrowserLoginOptionsController() {
        this.setName("Login Link Options");
        this.setDescription("Copy the link into your preferred browser or open the Browser Login in the default browser.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected BrowserLoginOptionsControl createComponent() {
        BrowserLoginOptionsControl c = new BrowserLoginOptionsControl();
        this.clickListener = ignored -> {
            this.doValidate();
            if (c.isValid()) {
                this.getDescriptor().doNextClick();
            }
        };
        c.addChangeListener(this.clickListener);
        return c;
    }

    protected String getFirstError(BrowserLoginOptionsControl component) {
        String error = null;
        if (StringUtilities.isNullOrEmpty((String)component.getAuthString())) {
            error = "Error: Please check your network and proxy settings.";
        } else if (!component.isLinkCopied() && !component.isBrowserLoginClicked()) {
            error = "Copy the link or click on the Browser Login button.";
        }
        return error;
    }

    protected void readSettings(WizardDescriptor settings) {
        ((BrowserLoginOptionsControl)this.component()).setLinkCopied(false);
        ((BrowserLoginOptionsControl)this.component()).setBrowserLoginClicked(false);
        CloudAuth cloudAuth = CloudAuth.getDefault();
        boolean switchOrg = Boolean.TRUE.equals(settings.getProperty("licensing.switch-org.maltegoId"));
        ((BrowserLoginOptionsControl)this.component()).setAuthString(cloudAuth.getAuthUrl(false, true, switchOrg));
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty(USE_SYSTEM_BROWSER, (Object)((BrowserLoginOptionsControl)this.component()).isBrowserLoginClicked());
    }
}

