/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import com.pinkmatter.modules.flamingo.LAFConfiguration;
import com.pinkmatter.modules.flamingo.RibbonRootPaneLayout;
import com.pinkmatter.spi.flamingo.RibbonComponentProvider;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static ActionListener resetAction = null;

    public static void setResetAction(ActionListener action) {
        resetAction = action;
    }

    public void restored() {
        System.setProperty("netbeans.winsys.no_toolbars", "true");
        SwingUtilities.invokeLater(() -> {
            JComponent toolbar = null;
            try {
                Installer.initLAF();
                JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                JComponent t = toolbar = RibbonComponentProvider.getDefault().createRibbon();
                toolbar.addPropertyChangeListener(evt -> {
                    if ("UI".equals(evt.getPropertyName())) {
                        frame.getRootPane().setLayout(new RibbonRootPaneLayout(frame.getRootPane().getLayout(), t));
                        frame.getRootPane().getLayeredPane().add((Component)t, 0);
                    }
                });
                frame.getRootPane().setLayout(new RibbonRootPaneLayout(frame.getRootPane().getLayout(), toolbar));
                toolbar.putClientProperty("layeredContainerLayer", 0);
                frame.getRootPane().getLayeredPane().add((Component)toolbar, 0);
            }
            finally {
                JComponent t = toolbar;
                UIRunQueue.instance().queue(3, "Something went very wrong...", () -> {
                    boolean fail;
                    boolean bl = fail = t == null || !t.isShowing() || t.getBounds().isEmpty();
                    if (fail) {
                        String msg = "Something went very wrong... Some of the core Maltego modules failed to load. Do you want to try and do a factory reset? Note that all custom configuration will be lost.";
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                        nd.setMessageType(0);
                        String reset = "Factory Reset";
                        nd.setOptions(new Object[]{reset, "Exit"});
                        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (reset.equals(result)) {
                            resetAction.actionPerformed(null);
                        }
                        LifecycleManager.getDefault().exit();
                    }
                });
            }
        });
    }

    private static void printAll(JComponent c, int indent) {
        Installer.printI(c.getClass().getName(), indent);
        Installer.printI("isShowing=" + c.isShowing(), indent);
        Installer.printI("getBounds=" + c.getBounds(), indent);
        Installer.printI("getLocation=" + c.getLocation(), indent);
        Installer.printI("getSize=" + c.getSize(), indent);
        Installer.printI("getVisibleRect=" + c.getVisibleRect(), indent);
        for (Component component : c.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            Installer.printAll((JComponent)component, indent + 1);
        }
    }

    private static void printI(String msg, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("   ");
        }
        System.out.println(msg);
    }

    private static void initLAF() {
        UIManager.getDefaults().putDefaults(LAFConfiguration.getClassDefaults());
    }
}

