/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.util.HashSet;
import org.openide.util.Exceptions;

class DeleteBranchAction
extends AbstractAction {
    public DeleteBranchAction() {
        super("deleteBranch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        try {
            this.deleteBranch(ctx, payload);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            cb.completed(Payloads.getEmpty());
        }
    }

    public void deleteBranch(AutomationContext ctx, Payload payload) throws GraphStoreException {
        GraphID graphID = ctx.getTargetGraphID();
        HashSet<EntityID> deleted = new HashSet<EntityID>();
        HashSet<LinkID> visited = new HashSet<LinkID>();
        HashSet<LinkID> fixedLinks = new HashSet<LinkID>();
        HashSet<EntityID> potentialDeletes = new HashSet<EntityID>();
        for (MaltegoEntity p : payload.getEntities()) {
            this.deleteBranch((EntityID)p.getID(), graphID, deleted, visited, potentialDeletes, fixedLinks, true);
        }
        for (LinkID linkID : fixedLinks) {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            EntityID targetID = structureReader.getTarget(linkID);
            this.deleteClosedLoops(targetID, graphID, potentialDeletes, fixedLinks);
        }
        HashSet<EntityID> entitiesIDs = new HashSet<EntityID>(deleted);
        entitiesIDs.addAll(potentialDeletes);
        if (!entitiesIDs.isEmpty()) {
            String description = "%s " + GraphTransactionHelper.getDescriptionForEntityIDs((GraphID)graphID, entitiesIDs, (boolean)true);
            SimilarStrings descriptions = new SimilarStrings(description, "Delete", "Add");
            GraphTransactionHelper.doDeleteEntities((SimilarStrings)descriptions, (GraphID)graphID, entitiesIDs);
        }
    }

    private void deleteClosedLoops(EntityID id, GraphID graphID, HashSet<EntityID> potentialDeletes, HashSet<LinkID> fixedLinks) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        if (potentialDeletes.contains(id)) {
            potentialDeletes.remove(id);
            for (EntityID childId : structureReader.getChildren(id)) {
                this.deleteClosedLoops(childId, graphID, potentialDeletes, fixedLinks);
            }
        }
    }

    private void deleteBranch(EntityID entityID, GraphID graphID, HashSet<EntityID> deleted, HashSet<LinkID> visited, HashSet<EntityID> potentialDeletes, HashSet<LinkID> fixedLinks, boolean force) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        boolean allParentsDead = true;
        if (!force) {
            for (LinkID linkID : structureReader.getIncoming(entityID)) {
                EntityID parentID = structureReader.getSource(linkID);
                if (deleted.contains(parentID)) continue;
                allParentsDead = false;
                if (visited.contains(linkID)) continue;
                fixedLinks.add(linkID);
            }
        }
        if (allParentsDead) {
            deleted.add(entityID);
            potentialDeletes.remove(entityID);
        } else {
            potentialDeletes.add(entityID);
        }
        for (LinkID linkID : structureReader.getOutgoing(entityID)) {
            fixedLinks.remove(linkID);
            if (visited.contains(linkID)) continue;
            visited.add(linkID);
            EntityID targetID = structureReader.getTarget(linkID);
            this.deleteBranch(targetID, graphID, deleted, visited, potentialDeletes, fixedLinks, false);
        }
    }
}

