/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws;

import com.paterva.maltego.pws.AccountTableModel;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class RegistryAccountTableModel
extends AccountTableModel {
    private final PublicWebServices webServiceRegistry = PublicWebServices.getDefault();

    public RegistryAccountTableModel() {
        this.webServiceRegistry.addPropertyChangeListener(evt -> {
            if ("serviceAdded".equals(evt.getPropertyName())) {
                RegistryAccountTableModel.runInEDT(() -> this.fireTableDataChanged());
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.webServiceRegistry.size();
    }

    @Override
    public List<PublicWebService> getServices() {
        ArrayList<PublicWebService> services = new ArrayList<PublicWebService>(this.webServiceRegistry.getAll());
        Collections.sort(services);
        return services;
    }

    public void remove(int[] rows) {
        int smallest = Integer.MAX_VALUE;
        int largest = -1;
        List<PublicWebService> services = this.getServices();
        ArrayList<PublicWebService> toRemove = new ArrayList<PublicWebService>();
        for (int row : rows) {
            smallest = Math.min(smallest, row);
            largest = Math.max(largest, row);
            toRemove.add(services.get(row));
        }
        Object object = toRemove.iterator();
        while (object.hasNext()) {
            PublicWebService service = (PublicWebService)object.next();
            try {
                this.webServiceRegistry.remove(service.getName());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.fireTableRowsDeleted(smallest, largest);
    }

    private static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

