/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.data;

import com.paterva.graph.store.pandora.data.DataCache;
import com.paterva.graph.store.pandora.data.EntityTypeCache;
import com.paterva.graph.store.pandora.data.PandoraGraphDataStoreReader;
import com.paterva.graph.store.pandora.parts.PandoraPartsWriter;
import com.paterva.graph.store.props.CachedPropertiesUtil;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.cache.FifoCache;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.serializers.map.PartMapWriter;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraQuery;
import com.pinkmatter.pandora.PandoraQueryResult;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PandoraGraphDataStoreWriter
extends PandoraPartsWriter
implements GraphDataStoreWriter {
    private static final Logger LOG = Logger.getLogger(PandoraGraphDataStoreWriter.class.getName());
    private final PartMapWriter _mapWriter = new PartMapWriter();
    private final EntityRegistry _entityRegistry;
    private final LinkRegistry _linkRegistry;
    private final PandoraGraphDataStoreReader _reader;
    private GraphDataMods _eventMods;

    public PandoraGraphDataStoreWriter(GraphID id, PandoraGraphDataStoreReader reader, PropertyChangeSupport changeSupport) {
        super(id, changeSupport);
        this._reader = reader;
        this._entityRegistry = EntityRegistry.forGraphID((GraphID)id);
        if (this._entityRegistry == null) {
            throw new IllegalArgumentException("Entity registry not found for graph id: " + id);
        }
        this._linkRegistry = LinkRegistry.forGraphID((GraphID)id);
        if (this._linkRegistry == null) {
            throw new IllegalArgumentException("Link registry not found for graph id: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putEntities(Collection<MaltegoEntity> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoEntity entity : entities) {
                this.putEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public synchronized void putEntity(MaltegoEntity entity) throws GraphStoreException {
        this.beginUpdate();
        try {
            boolean typesInitialized;
            CachedPropertiesUtil.updateCachedProperties((SpecRegistry)this._entityRegistry, (MaltegoPart)entity);
            Map<String, Object> map = this.toMap((MaltegoPart)entity, false);
            EntityID entityID = (EntityID)entity.getID();
            long id = entityID.getValue();
            this.getEntityStore().add(id, map);
            this.getEntityCache().put((Object)entityID, (Object)entity);
            SkeletonProviders.entitiesForGraph((GraphID)this.getGraphID()).putSkeleton(entity);
            EntityTypeCache typeCache = this.getTypeCache();
            boolean bl = typesInitialized = typeCache != null && typeCache.isInitialized();
            if (typesInitialized) {
                String typeName = entity.getTypeName();
                LOG.log(Level.FINE, "Add entity {0} {1}", new Object[]{entityID, typeName});
                typeCache.putType(entityID, typeName);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not save entity with id " + entity.getID(), (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLinks(Collection<MaltegoLink> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoLink link : links) {
                this.putLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void putLink(MaltegoLink link) throws GraphStoreException {
        this.beginUpdate();
        try {
            CachedPropertiesUtil.updateCachedProperties((SpecRegistry)this._linkRegistry, (MaltegoPart)link);
            Map<String, Object> map = this.toMap((MaltegoPart)link, false);
            LOG.log(Level.FINE, "Add link {0}", link.getID());
            this.getLinkStore().add(((LinkID)link.getID()).getValue(), map);
            SkeletonProviders.linksForGraph((GraphID)this.getGraphID()).putSkeleton(link);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not save link with id " + link.getID(), (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntities(Collection<EntityID> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (EntityID entity : entities) {
                this.removeEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeEntity(EntityID id) throws GraphStoreException {
        this.beginUpdate();
        try {
            LOG.log(Level.FINE, "Remove entity {0}", id);
            this.getEntityCache().remove((Object)id);
            this.getEntityStore().remove(id.getValue());
            EntityTypeCache typeCache = this.getTypeCache();
            if (typeCache != null && typeCache.isInitialized()) {
                typeCache.removeType(id);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove entity with id " + id, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinks(Collection<LinkID> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (LinkID link : links) {
                this.removeLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeLink(LinkID id) throws GraphStoreException {
        this.beginUpdate();
        try {
            LOG.log(Level.FINE, "Remove link {0}", id);
            this.getLinkStore().remove(id.getValue());
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not remove link with id " + id, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntities(Collection<MaltegoEntity> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoEntity entity : entities) {
                this.replaceEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void updateEntity(MaltegoEntity entity) throws GraphStoreException {
        this.updateEntities(Collections.singleton(entity));
    }

    private void replaceEntity(MaltegoEntity entity) throws GraphStoreException {
        this.beginUpdate();
        try {
            CachedPropertiesUtil.updateCachedProperties((SpecRegistry)this._entityRegistry, (MaltegoPart)entity);
            Map<String, Object> map = this.toMap((MaltegoPart)entity, false);
            EntityID entityID = (EntityID)entity.getID();
            long id = entityID.getValue();
            LOG.log(Level.FINE, "Update entity {0}", entityID);
            this.getEntityStore().remove(id);
            this.getEntityStore().add(id, map);
            FifoCache<EntityID, MaltegoEntity> entityCache = this.getEntityCache();
            entityCache.remove((Object)entityID);
            entityCache.put((Object)entityID, (Object)entity);
            EntityTypeCache typeCache = this.getTypeCache();
            if (typeCache != null && typeCache.isInitialized()) {
                typeCache.putType(entityID, entity.getTypeName());
            }
            this.getEventMods().getEntitiesUpdated().put(entityID, entity);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not save entity with id " + entity.getID(), (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLinks(Collection<MaltegoLink> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoLink link : links) {
                this.replaceLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void updateLink(MaltegoLink link) throws GraphStoreException {
        this.updateLinks(Collections.singleton(link));
    }

    private void replaceLink(MaltegoLink link) throws GraphStoreException {
        this.beginUpdate();
        LinkID linkID = (LinkID)link.getID();
        try {
            CachedPropertiesUtil.updateCachedProperties((SpecRegistry)this._linkRegistry, (MaltegoPart)link);
            Map<String, Object> map = this.toMap((MaltegoPart)link, false);
            LOG.log(Level.FINE, "Update link {0}", linkID);
            this.getLinkStore().remove(linkID.getValue());
            this.getLinkStore().add(linkID.getValue(), map);
            this.getEventMods().getLinksUpdated().put(linkID, link);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Could not save link with id " + linkID, (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    protected void fireEvent() {
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphDataMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                LOG.log(Level.FINE, "Fire events: {0}", eventMods);
                eventMods.makeReadOnly();
                this.getChangeSupport().firePropertyChange("partsChanged", null, eventMods);
            }
        }
    }

    private GraphDataMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphDataMods();
        }
        return this._eventMods;
    }

    private Map<String, Object> toMap(MaltegoPart part, boolean addDefaults) {
        Map map = this._mapWriter.toMap(part, addDefaults);
        map = this._mapWriter.escapeDots(map);
        LOG.log(Level.FINER, "Escaped map:\n{0}", map);
        return map;
    }

    private FifoCache<EntityID, MaltegoEntity> getEntityCache() {
        DataCache cache = this.getDataCache();
        return cache.getEntityCache();
    }

    public DataCache getDataCache() {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        DataCache cache = (DataCache)gud.get((Object)(key = DataCache.class.getName()));
        if (cache == null) {
            cache = new DataCache();
            gud.put((Object)key, (Object)cache);
        }
        return cache;
    }

    private EntityTypeCache getTypeCache() throws GraphStoreException {
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        String key = EntityTypeCache.class.getName();
        return (EntityTypeCache)gud.get((Object)key);
    }

    public void convertAttachmentIDsToPaths(Map<Integer, String> idToPaths) throws GraphStoreException {
        try {
            PandoraQueryResult result = this.getArtifactsWithAttachments();
            for (Artifact artifact : result) {
                this._mapWriter.convertAttachmentIDsToPaths((Map)artifact, idToPaths);
                this.getEntityStore().remove(artifact.getKey());
            }
            for (Artifact artifact : result) {
                this.getEntityStore().add(artifact.getKey(), (Map)artifact);
            }
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public void convertAttachmentPathsToIDs(Map<Integer, String> idToPaths) throws GraphStoreException {
        try {
            PandoraQueryResult result = this.getArtifactsWithAttachments();
            for (Artifact artifact : result) {
                this._mapWriter.convertAttachmentPathsToIDs((Map)artifact, idToPaths);
                this.getEntityStore().remove(artifact.getKey());
            }
            for (Artifact artifact : result) {
                this.getEntityStore().add(artifact.getKey(), (Map)artifact);
            }
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private PandoraQueryResult getArtifactsWithAttachments() throws PandoraException {
        PandoraQuery query = this._reader.getEntitySearch().query().filterContains("hasAttachments", (Object[])new Boolean[]{true});
        PandoraQueryResult result = query.list();
        if (result.isEmpty()) {
            try {
                String filterKey = "properties" + "." + this._mapWriter.escapeDots("property.atts31415237681098") + "." + "type";
                PandoraFilter.Contains propertyFilter = new PandoraFilter.Contains(filterKey, new Object[]{"attachments"});
                PandoraQuery alternateQuery = this._reader.getEntitySearch().query().filter(new PandoraFilter[]{propertyFilter});
                PandoraQueryResult alternateResult = alternateQuery.list();
                if (alternateResult.getCount() > 0) {
                    LOG.warning("hasAttachments was not found, but attachments property exists. Fixing the graph");
                    return alternateResult;
                }
            }
            catch (PandoraException e) {
                LOG.log(Level.WARNING, "Exception occured during alternative query.", e);
            }
        }
        return result;
    }
}

