/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.Set;

public abstract class IterationScopeNode
extends JavaScriptNode {
    public static IterationScopeNode create(FrameDescriptor frameDescriptor, JSReadFrameSlotNode[] reads, JSWriteFrameSlotNode[] writes, FrameSlot blockScopeSlot) {
        return new FrameIterationScopeNode(frameDescriptor, reads, writes, blockScopeSlot);
    }

    public abstract VirtualFrame execute(VirtualFrame var1);

    public abstract void executeCopy(VirtualFrame var1, VirtualFrame var2);

    public abstract void exitScope(VirtualFrame var1, VirtualFrame var2);

    public static final class FrameIterationScopeNode
    extends IterationScopeNode {
        private final FrameDescriptor frameDescriptor;
        @Node.Children
        private final JSReadFrameSlotNode[] reads;
        @Node.Children
        private final JSWriteFrameSlotNode[] writes;
        private final FrameSlot blockScopeSlot;

        public FrameIterationScopeNode(FrameDescriptor frameDescriptor, JSReadFrameSlotNode[] reads, JSWriteFrameSlotNode[] writes, FrameSlot blockScopeSlot) {
            this.frameDescriptor = frameDescriptor;
            this.reads = reads;
            this.writes = writes;
            this.blockScopeSlot = blockScopeSlot;
            assert (reads.length == writes.length);
        }

        @Override
        public VirtualFrame execute(VirtualFrame frame) {
            MaterializedFrame prevFrame = JSFrameUtil.castMaterializedFrame(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.blockScopeSlot));
            MaterializedFrame nextFrame = Truffle.getRuntime().createVirtualFrame(frame.getArguments(), this.frameDescriptor).materialize();
            this.writes[0].executeWithFrame((Frame)nextFrame, this.reads[0].execute((VirtualFrame)prevFrame));
            this.copySlots((VirtualFrame)nextFrame, (VirtualFrame)prevFrame);
            frame.setObject(this.blockScopeSlot, (Object)nextFrame);
            return prevFrame;
        }

        @Override
        public void executeCopy(VirtualFrame frame, VirtualFrame prevFrame) {
            MaterializedFrame nextFrame = JSFrameUtil.castMaterializedFrame(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.blockScopeSlot));
            assert (FrameUtil.getObjectSafe((Frame)nextFrame, (FrameSlot)nextFrame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) == FrameUtil.getObjectSafe((Frame)prevFrame, (FrameSlot)prevFrame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)));
            this.copySlots(prevFrame, (VirtualFrame)nextFrame);
            this.exitScope(frame, prevFrame);
        }

        @Override
        public void exitScope(VirtualFrame frame, VirtualFrame prevFrame) {
            frame.setObject(this.blockScopeSlot, (Object)prevFrame);
        }

        @ExplodeLoop
        private void copySlots(VirtualFrame nextFrame, VirtualFrame frame) {
            for (int i = 1; i < this.reads.length; ++i) {
                this.writes[i].executeWithFrame((Frame)nextFrame, this.reads[i].execute(frame));
            }
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new FrameIterationScopeNode(this.frameDescriptor, FrameIterationScopeNode.cloneUninitialized(this.reads, materializedTags), FrameIterationScopeNode.cloneUninitialized(this.writes, materializedTags), this.blockScopeSlot);
        }
    }
}

