/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.tests;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.io.FilenameUtils;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class AutomaticCertificateTestsAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(AutomaticCertificateTestsAction.class.getName());
    private static final String JAVA_PATH = "\"C:\\Program Files\\Java\\jdk1.8.0_162";
    private static final String MALTEGO_TEST_FOLDER = "G:\\dev\\Maltego3\\trunk\\src\\Test\\";
    private static final String SERVER_JAR = "\"G:\\dev\\Maltego3\\trunk\\src\\Test\\test-certificate-web-server\\target\\test-certificate-web-server-1.0.0.jar\"";
    private static final String CERTS_FOLDER = "G:\\dev\\Maltego3\\trunk\\src\\Test\\certificates\\certs\\";
    private static final String TEST_PORT = "8888";
    private static final String TEST_URL = "https://www.example.com";
    private static final String LOG_FILE = "G:\\dev\\Maltego3\\trunk\\src\\Test\\certificates\\certs\\AutomaticCertificateTestsAction.log";
    private static final String STORE_PASS = " -storepass changeit -noprompt";
    private static final String KEYTOOL_PATH = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\keytool\"";
    private static final String JAVA_EXE = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\java.exe\"";
    private static final String TRUSTED_KEYSTORE_ARG = " -keystore \"C:\\Program Files\\Java\\jdk1.8.0_162\\jre\\lib\\security\\cacerts\" ";
    private static final String FILE_ARG = " -file \"G:\\dev\\Maltego3\\trunk\\src\\Test\\certificates\\certs\\";
    private static final String CERT_CA_ALIAS = "\"patervacatest\" ";
    private static final String CERT_ALIAS = "\"patervatest\" ";
    private static final String CERT_NOT_PRESENT = "-";
    private static final Map<File, CertificateDefinition> _caCerts = new HashMap<File, CertificateDefinition>();
    private static final Map<File, CertificateDefinition> _serverCerts = new HashMap<File, CertificateDefinition>();
    private static final CertStatus _status = new CertStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        LOG.setLevel(Level.INFO);
        this.setupLogFile();
        File folder = new File(CERTS_FOLDER);
        for (File file : folder.listFiles()) {
            X509Certificate cert;
            if (!file.isFile() || !file.canRead() || (cert = CertificateUtils.decode((File)file, (boolean)false, (boolean)true)) == null) continue;
            CertificateDefinition certDef = new CertificateDefinition(cert);
            if (certDef.isCaCertificate()) {
                _caCerts.put(file, certDef);
                continue;
            }
            _serverCerts.put(file, certDef);
        }
        try {
            SlownessDetector.setEnabled((boolean)false);
            AutomaticCertificateTestsAction.deleteCert(CERT_ALIAS);
            Thread.sleep(1000L);
            AutomaticCertificateTestsAction.deleteCert(CERT_CA_ALIAS);
            Thread.sleep(1000L);
            AutomaticCertificateTestsAction.stopWebServer();
            Thread.sleep(2000L);
            URL url = new URL("https://www.example.com:8888/hello");
            CertificateRepository certRepo = CertificateRepository.getDefault();
            for (Map.Entry<File, CertificateDefinition> serverKeystore : _serverCerts.entrySet()) {
                File outer = serverKeystore.getKey();
                X509Certificate serverCertReceived = serverKeystore.getValue().getCertificate();
                String baseName = FilenameUtils.getBaseName((String)outer.getAbsolutePath());
                File keyStore = new File(outer.getParentFile(), baseName + ".ca.chain.keystore.p12");
                if (!keyStore.isFile() || !keyStore.canRead()) continue;
                AutomaticCertificateTestsAction.startWebServer(keyStore);
                _status.setReceivedCert(outer.getName() + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)serverCertReceived)));
                Thread.sleep(2000L);
                _status.setJavaCa(CERT_NOT_PRESENT);
                this.caJavaLoop(certRepo, url, null, serverCertReceived);
                for (Map.Entry<File, CertificateDefinition> caJavaEntry : _caCerts.entrySet()) {
                    File caJava = caJavaEntry.getKey();
                    X509Certificate caJavaCert = caJavaEntry.getValue().getCertificate();
                    _status.setJavaCa(caJava.getName() + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)caJavaCert)));
                    AutomaticCertificateTestsAction.importCert(CERT_CA_ALIAS, caJava.getName());
                    Thread.sleep(1000L);
                    this.caJavaLoop(certRepo, url, caJavaCert, serverCertReceived);
                }
                AutomaticCertificateTestsAction.stopWebServer();
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException | MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
    }

    private void setupLogFile() {
        try {
            FileHandler fh = new FileHandler(LOG_FILE);
            LOG.addHandler(fh);
            SimpleFormatter formatter = new SimpleFormatter();
            fh.setFormatter(formatter);
            LOG.setUseParentHandlers(false);
        }
        catch (IOException | SecurityException ex1) {
            ex1.printStackTrace();
        }
    }

    private void caJavaLoop(CertificateRepository certRepo, URL url, X509Certificate caJavaCert, X509Certificate serverCertReceived) throws InterruptedException {
        _status.setJavaServer(CERT_NOT_PRESENT);
        this.serverJavaLoop(certRepo, url, caJavaCert, serverCertReceived, null);
        for (Map.Entry<File, CertificateDefinition> serverJavaCerts : _serverCerts.entrySet()) {
            File serverJava = serverJavaCerts.getKey();
            X509Certificate serverJavaCert = serverJavaCerts.getValue().getCertificate();
            _status.setJavaServer(serverJava.getName() + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)serverJavaCert)));
            AutomaticCertificateTestsAction.importCert(CERT_ALIAS, serverJava.getName());
            Thread.sleep(1000L);
            this.serverJavaLoop(certRepo, url, caJavaCert, serverCertReceived, serverJavaCert);
        }
        AutomaticCertificateTestsAction.deleteCert(CERT_CA_ALIAS);
        Thread.sleep(1000L);
    }

    private void serverJavaLoop(CertificateRepository certRepo, URL url, X509Certificate caJavaCert, X509Certificate serverCertReceived, X509Certificate serverJavaCert) throws InterruptedException {
        for (Map.Entry<File, CertificateDefinition> caMaltegoEntry : _caCerts.entrySet()) {
            File caMaltego = caMaltegoEntry.getKey();
            X509Certificate caMaltegoCert = caMaltegoEntry.getValue().getCertificate();
            if (caMaltegoCert == null) continue;
            _status.setMaltegoCa(CERT_NOT_PRESENT);
            this.doInnerMostLoop(certRepo, url, caJavaCert, serverCertReceived, serverJavaCert);
            boolean caTrusted = true;
            _status.setMaltegoCa(caMaltego.getName() + AutomaticCertificateTestsAction.osTrusted(caTrusted) + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)caMaltegoCert)));
            certRepo.update(caMaltegoCert, caTrusted, null);
            Thread.sleep(20L);
            this.doInnerMostLoop(certRepo, url, caJavaCert, serverCertReceived, serverJavaCert);
            caTrusted = false;
            _status.setMaltegoCa(caMaltego.getName() + AutomaticCertificateTestsAction.osTrusted(caTrusted) + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)caMaltegoCert)));
            certRepo.update(caMaltegoCert, caTrusted, null);
            Thread.sleep(20L);
            this.doInnerMostLoop(certRepo, url, caJavaCert, serverCertReceived, serverJavaCert);
            certRepo.remove(caMaltegoCert);
            Thread.sleep(20L);
        }
        AutomaticCertificateTestsAction.deleteCert(CERT_ALIAS);
        Thread.sleep(1000L);
    }

    private void doInnerMostLoop(CertificateRepository certRepo, URL url, X509Certificate caJavaCert, X509Certificate serverCertReceived, X509Certificate serverJavaCert) throws InterruptedException {
        for (Map.Entry<File, CertificateDefinition> serverMaltegoEntry : _serverCerts.entrySet()) {
            File serverMaltego = serverMaltegoEntry.getKey();
            X509Certificate serverMaltegoCert = serverMaltegoEntry.getValue().getCertificate();
            if (serverMaltegoCert == null) continue;
            _status.setMaltegoServer(CERT_NOT_PRESENT);
            CertificateTrustHandler.CertificateActions action = AutomaticCertificateTestsAction.test(url.toString());
            Thread.sleep(20L);
            this.verifyBehaviour(caJavaCert, serverCertReceived, serverJavaCert, certRepo, url, action);
            boolean serverTrusted = true;
            _status.setMaltegoServer(serverMaltego.getName() + AutomaticCertificateTestsAction.osTrusted(serverTrusted) + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)serverMaltegoCert)));
            certRepo.update(serverMaltegoCert, serverTrusted, null);
            Thread.sleep(20L);
            action = AutomaticCertificateTestsAction.test(url.toString());
            Thread.sleep(20L);
            this.verifyBehaviour(caJavaCert, serverCertReceived, serverJavaCert, certRepo, url, action);
            serverTrusted = false;
            _status.setMaltegoServer(serverMaltego.getName() + AutomaticCertificateTestsAction.osTrusted(serverTrusted) + AutomaticCertificateTestsAction.osValid(CertificateUtils.isValid((X509Certificate)serverMaltegoCert)));
            certRepo.update(serverMaltegoCert, serverTrusted, null);
            Thread.sleep(20L);
            action = AutomaticCertificateTestsAction.test(url.toString());
            Thread.sleep(20L);
            this.verifyBehaviour(caJavaCert, serverCertReceived, serverJavaCert, certRepo, url, action);
            certRepo.remove(serverMaltegoCert);
            Thread.sleep(20L);
        }
    }

    private void verifyBehaviour(X509Certificate caJavaCert, X509Certificate serverCertReceived, X509Certificate serverJavaCert, CertificateRepository certRepo, URL url, CertificateTrustHandler.CertificateActions action) {
        boolean trustedCaJava = AutomaticCertificateTestsAction.checkCertInKeyStore(CERT_CA_ALIAS) && CertificateUtils.isValid((X509Certificate)caJavaCert) && CertificateUtils.isSigningCa((X509Certificate)caJavaCert, (X509Certificate)serverCertReceived);
        boolean trustedServerJava = AutomaticCertificateTestsAction.checkCertInKeyStore(CERT_ALIAS) && CertificateUtils.isValid((X509Certificate)serverJavaCert) && serverJavaCert.equals(serverCertReceived);
        boolean trustedJava = trustedCaJava || trustedServerJava;
        boolean serverCertInCertMan = certRepo.contains(serverCertReceived);
        boolean caCertInCertMan = certRepo.containsCa(serverCertReceived);
        boolean inCertMan = serverCertInCertMan || caCertInCertMan;
        boolean trustedCaMaltego = certRepo.containsCa(serverCertReceived, true) && certRepo.isCaValid(serverCertReceived);
        boolean trustedServerMaltego = CertificateUtils.isValid((X509Certificate)serverCertReceived) && certRepo.contains(serverCertReceived, true);
        boolean trustedCertman = trustedCaMaltego && !certRepo.contains(serverCertReceived) || trustedServerMaltego;
        boolean hasSanCn = CertificateUtils.hasParsableSansOrCN((X509Certificate)serverCertReceived);
        boolean matchSanCn = CertificateUtils.urlMatchesSansOrCN((X509Certificate)serverCertReceived, (URL)url);
        boolean matchHost = certRepo.urlMatchesCertHostnames(serverCertReceived, url);
        int caseNum = 4;
        switch (action) {
            case ALLOW: {
                caseNum = 1;
                break;
            }
            case BLOCK: 
            case DATE_INVALID: 
            case BLACKLISTED: {
                caseNum = 4;
                break;
            }
            case SHOW_STORE: {
                caseNum = 6;
                break;
            }
            case SHOW_STORE_ATTACH_HOSTNAME: {
                caseNum = 7;
                break;
            }
            case SHOW_ATTACH_HOSTNAME: {
                caseNum = 8;
                break;
            }
        }
        AutomaticCertificateTestsAction.createOutput(trustedJava, inCertMan, trustedCertman, hasSanCn, matchSanCn, matchHost, Integer.toString(caseNum));
    }

    private static void createOutput(boolean trustedJava, boolean inCertMan, boolean trustedCertman, boolean hasSanCn, boolean matchSanCn, boolean matchHost, String resultCase) {
        String[] pass = AutomaticCertificateTestsAction.evalSuccess(trustedJava, inCertMan, trustedCertman, hasSanCn, matchSanCn, matchHost, resultCase);
        String expectedResultCase = pass[0];
        String passString = pass[1];
        AutomaticCertificateTestsAction.printCommand(AutomaticCertificateTestsAction.os(_status._javaCa) + AutomaticCertificateTestsAction.os(_status._javaServer) + AutomaticCertificateTestsAction.os(_status._maltegoCa) + AutomaticCertificateTestsAction.os(_status._maltegoServer) + AutomaticCertificateTestsAction.os(_status._receivedCert) + AutomaticCertificateTestsAction.os(trustedJava) + AutomaticCertificateTestsAction.os(inCertMan) + AutomaticCertificateTestsAction.os(trustedCertman) + AutomaticCertificateTestsAction.os(hasSanCn) + AutomaticCertificateTestsAction.os(matchSanCn) + AutomaticCertificateTestsAction.os(matchHost) + AutomaticCertificateTestsAction.os(expectedResultCase) + AutomaticCertificateTestsAction.os(resultCase) + AutomaticCertificateTestsAction.os(passString), Level.INFO);
    }

    private static String[] evalSuccess(boolean trustedJava, boolean inCertMan, boolean trustedCertman, boolean hasSanCn, boolean matchSanCn, boolean matchHost, String resultCase) {
        boolean valid;
        String expectedResultCase = "";
        boolean bl = valid = !_status._receivedCert.contains("invalid date");
        if (trustedJava && !inCertMan && hasSanCn && matchSanCn) {
            expectedResultCase = "1";
        } else if (inCertMan && trustedCertman && hasSanCn && matchSanCn) {
            expectedResultCase = "1";
        } else if (inCertMan && trustedCertman && !hasSanCn && matchHost) {
            expectedResultCase = "1";
        } else if (inCertMan && !trustedCertman) {
            expectedResultCase = "4";
        } else if (hasSanCn && !matchSanCn) {
            expectedResultCase = "4";
        } else if (!trustedJava && !inCertMan && hasSanCn && matchSanCn) {
            expectedResultCase = "6";
        } else if (!inCertMan && !hasSanCn) {
            expectedResultCase = "7";
        } else if (inCertMan && trustedCertman && !hasSanCn && !matchHost) {
            expectedResultCase = "8";
        }
        if (!"4".equals(expectedResultCase) && !valid) {
            expectedResultCase = "4";
        }
        String passString = resultCase.equals(expectedResultCase) ? "SUCCESS" : "FAILED";
        return new String[]{expectedResultCase, passString};
    }

    private static String os(String string) {
        String column = string + "\t";
        return column;
    }

    private static String os(boolean state) {
        String column = (state ? "Y" : "N") + "\t";
        return column;
    }

    private static String osTrusted(boolean state) {
        String column = state ? ": trusted" : ": blacklisted";
        return column;
    }

    private static String osValid(boolean state) {
        String column = state ? ": date valid" : ": invalid date";
        return column;
    }

    private static void startWebServer(File keyStore) {
        String command = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\java.exe\" -jar \"G:\\dev\\Maltego3\\trunk\\src\\Test\\test-certificate-web-server\\target\\test-certificate-web-server-1.0.0.jar\" 8888 \"" + keyStore.getAbsolutePath() + "\"";
        AutomaticCertificateTestsAction.printCommand("Start web server with keystore " + keyStore.getAbsolutePath(), Level.FINE);
        boolean success = AutomaticCertificateTestsAction.runCommand(command, "Started Main in");
    }

    private static boolean stopWebServer() {
        boolean success = true;
        String netstat = AutomaticCertificateTestsAction.getCommandOuput("netstat -ano | findstr :8888");
        if (StringUtilities.isNullOrEmpty((String)netstat)) {
            AutomaticCertificateTestsAction.printCommand("isNullOrEmpty", Level.FINEST);
            success = false;
        } else {
            String line;
            String trimmedLine;
            String[] split;
            AutomaticCertificateTestsAction.printCommand(netstat, Level.FINEST);
            netstat = netstat.trim();
            String pidString = null;
            String[] stringArray = split = netstat.split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n && "0".equals((pidString = (trimmedLine = (line = stringArray[i]).trim()).substring(trimmedLine.lastIndexOf(" ") + 1)).trim()); ++i) {
            }
            try {
                int pid = Integer.parseInt(pidString.trim());
                String killPid = AutomaticCertificateTestsAction.getCommandOuput("taskkill -pid " + pid + " /f");
                if (StringUtilities.isNullOrEmpty((String)killPid)) {
                    success = false;
                } else {
                    AutomaticCertificateTestsAction.printCommand(killPid, Level.FINEST);
                }
            }
            catch (NumberFormatException ex) {
                AutomaticCertificateTestsAction.printCommand(ex.getMessage(), Level.FINEST);
                success = false;
            }
        }
        AutomaticCertificateTestsAction.printCommand((success ? "SUCCESS" : "FAILED") + ": Stop web server", Level.FINE);
        return success;
    }

    private static String getCommandOuput(String command) {
        String output = null;
        try {
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/C", command);
            Process process = builder.start();
            process.waitFor();
            int bytesRead = -1;
            byte[] bytes = new byte[1024];
            output = "";
            while ((bytesRead = process.getInputStream().read(bytes)) > -1) {
                output = output + new String(bytes, 0, bytesRead);
            }
        }
        catch (IOException | InterruptedException ex) {
            output = null;
        }
        return output;
    }

    private static boolean checkCertInKeyStore() {
        return AutomaticCertificateTestsAction.checkCertInKeyStore(null);
    }

    private static boolean checkCertInKeyStore(String alias) {
        String command = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\keytool\" -list -v  -keystore \"C:\\Program Files\\Java\\jdk1.8.0_162\\jre\\lib\\security\\cacerts\"  -storepass changeit -noprompt";
        if (alias != null) {
            command = command + " -alias " + alias;
        }
        boolean found = AutomaticCertificateTestsAction.runCommand(command, null);
        AutomaticCertificateTestsAction.printCommand((found ? "FOUND" : "NOT FOUND") + (alias == null ? " All certificates" : ": Certificate with alias " + alias) + " in keystore", Level.FINE);
        return found;
    }

    private static void importCert(String alias, String file) {
        String command = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\keytool\" -import -trustcacerts  -keystore \"C:\\Program Files\\Java\\jdk1.8.0_162\\jre\\lib\\security\\cacerts\"  -storepass changeit -noprompt -alias " + alias + FILE_ARG + file + "\"";
        boolean success = AutomaticCertificateTestsAction.runCommand(command, null);
        AutomaticCertificateTestsAction.checkCertInKeyStore(alias);
    }

    private static void deleteCert(String alias) {
        String command = "\"C:\\Program Files\\Java\\jdk1.8.0_162\\bin\\keytool\" -delete  -keystore \"C:\\Program Files\\Java\\jdk1.8.0_162\\jre\\lib\\security\\cacerts\"  -storepass changeit -noprompt -alias " + alias;
        boolean success = AutomaticCertificateTestsAction.runCommand(command, null);
        AutomaticCertificateTestsAction.checkCertInKeyStore(alias);
    }

    private static boolean runCommand(String command, String waitFor) {
        int exitValue = 1;
        try {
            AutomaticCertificateTestsAction.printCommand(command, Level.FINEST);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while (!((line = in.readLine()) == null || waitFor != null && line.contains(waitFor))) {
                AutomaticCertificateTestsAction.printCommand(line, Level.FINEST);
            }
            if (waitFor == null) {
                exitValue = process.waitFor();
                AutomaticCertificateTestsAction.printCommand("Exited with error code " + exitValue, Level.FINEST);
            }
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
        return exitValue == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertificateTrustHandler.CertificateActions test(String urlStr) {
        boolean worked = true;
        CertificateTrustHandler.CertificateActions action = null;
        try {
            SlownessDetector.setEnabled((boolean)false);
            URL url = new URL(urlStr);
            do {
                if ((action = AutomaticCertificateTestsAction.testUrl(url)) == null) continue;
                boolean bl = worked = action == CertificateTrustHandler.CertificateActions.ALLOW;
            } while (action == null);
        }
        catch (Exception ex) {
            worked = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
        AutomaticCertificateTestsAction.printCommand((worked ? "SUCCESS" : "FAILED") + ": Test URL " + urlStr, Level.FINE);
        return action;
    }

    private static CertificateTrustHandler.CertificateActions testUrl(URL url) {
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(30000);
        httpAgent.setReadTimeout(30000);
        Optional certOpt = Optional.ofNullable(null);
        CertificateTrustHandler.CertificateActions action = null;
        try {
            certOpt = httpAgent.getServerCertificate(true, false, true);
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            action = CertificateUtils.getCertActionFromException((NoTrustedCertificateChainFoundException)ex);
        }
        catch (IOException | GeneralSecurityException ex) {
            return null;
        }
        if (certOpt.isPresent()) {
            return CertificateTrustHandler.CertificateActions.ALLOW;
        }
        if (action != null) {
            switch (action) {
                case ALLOW: 
                case BLOCK: 
                case DATE_INVALID: 
                case BLACKLISTED: 
                case SHOW_STORE: 
                case SHOW_STORE_ATTACH_HOSTNAME: 
                case SHOW_ATTACH_HOSTNAME: {
                    return action;
                }
            }
            return null;
        }
        return CertificateTrustHandler.CertificateActions.BLOCK;
    }

    private static String[] parse(String command) {
        String[] options = command.trim().split("\\s+");
        return options;
    }

    private static void printCommand(String command, Level level) {
        LOG.log(level, command);
    }

    public String getName() {
        return "Automatic Certificate Tests";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static class CertStatus {
        private String _receivedCert;
        private String _javaCa;
        private String _javaServer;
        private String _maltegoCa;
        private String _maltegoServer;

        public String getReceivedCert() {
            return this._receivedCert;
        }

        public String getJavaCa() {
            return this._javaCa;
        }

        public String getJavaServer() {
            return this._javaServer;
        }

        public String getMaltegoCa() {
            return this._maltegoCa;
        }

        public String getMaltegoServer() {
            return this._maltegoServer;
        }

        public void setReceivedCert(String receivedCert) {
            this._receivedCert = receivedCert;
        }

        public void setJavaCa(String javaCa) {
            this._javaCa = javaCa;
        }

        public void setJavaServer(String javaServer) {
            this._javaServer = javaServer;
        }

        public void setMaltegoCa(String maltegoCa) {
            this._maltegoCa = maltegoCa;
        }

        public void setMaltegoServer(String maltegoServer) {
            this._maltegoServer = maltegoServer;
        }
    }
}

