/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list;

import javax.swing.SwingUtilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class OverviewReset {
    private static OverviewReset instance;
    private final String overviewTopComponentName = "SatelliteViewTopComponent";
    private final WindowManager manager = WindowManager.getDefault();
    private final TopComponent overviewTopComponent = this.manager.findTopComponent("SatelliteViewTopComponent");
    private final Mode maximizedMode;
    private final Mode minimizedMode = this.manager.findMode("rightSlidingSide");
    private boolean reset;

    public static OverviewReset getDefault() {
        if (instance == null) {
            instance = new OverviewReset();
        }
        return instance;
    }

    private OverviewReset() {
        this.maximizedMode = this.manager.findMode("MaltegoSatellite");
    }

    public static boolean isReset() {
        return instance != null && OverviewReset.instance.reset;
    }

    public void doReset() {
        this.maximizedMode.dockInto(this.overviewTopComponent);
        this.overviewTopComponent.open();
    }

    public void dock(boolean minMode) {
        this.reset = minMode;
        SwingUtilities.invokeLater(new Docker(minMode));
    }

    private class Docker
    implements Runnable {
        private final boolean minMode;

        public Docker(boolean minMode) {
            this.minMode = minMode;
        }

        @Override
        public void run() {
            TopComponent tc;
            Mode mode = this.minMode ? OverviewReset.this.minimizedMode : OverviewReset.this.maximizedMode;
            if (mode.canDock(tc = OverviewReset.this.overviewTopComponent)) {
                mode.dockInto(tc);
                if (!this.minMode) {
                    tc.open();
                }
            }
        }
    }
}

