/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.manager;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.impl.TabularGraphNameComparator;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.WeakListeners;

class MappingRegistryTableModel
extends RowTableModel<TabularGraph> {
    public static final String[] Columns = new String[]{"Name", "Description", "Entities", "Links"};
    private final MappingRegistry _registry;
    private final RegistryListener _listener;

    public MappingRegistryTableModel(MappingRegistry registry) {
        super(Columns, MappingRegistryTableModel.getSortedMappings(registry));
        this._registry = registry;
        this._listener = new RegistryListener(){

            public void typeAdded(RegistryEvent event) {
                MappingRegistryTableModel.this.refresh();
            }

            public void typeRemoved(RegistryEvent event) {
                MappingRegistryTableModel.this.refresh();
            }

            public void typeUpdated(RegistryEvent event) {
                MappingRegistryTableModel.this.refresh();
            }
        };
        this._registry.addListener((RegistryListener)WeakListeners.create(RegistryListener.class, (EventListener)this._listener, (Object)this._registry));
    }

    private static List<TabularGraph> getSortedMappings(MappingRegistry registry) {
        ArrayList<TabularGraph> list = new ArrayList<TabularGraph>(registry.getAll());
        Collections.sort(list, new TabularGraphNameComparator());
        return list;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public void refresh() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MappingRegistryTableModel.this.setRows(MappingRegistryTableModel.getSortedMappings(MappingRegistryTableModel.this._registry));
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Object getValueFor(TabularGraph row, int column) {
        switch (column) {
            case 0: {
                return row.getName();
            }
            case 1: {
                return row.getDescription();
            }
            case 2: {
                return row.getEntities().size();
            }
            case 3: {
                return row.getLinks().size();
            }
        }
        return null;
    }
}

