/* ISC license. */

#ifndef UTMPS_UTMPX_H
#define UTMPS_UTMPX_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <stdint.h>
#include <sys/time.h>

#define UTMPS_UT_LINESIZE 32
#define UTMPS_UT_NAMESIZE 32
#define UTMPS_UT_HOSTSIZE 256
#define UTMPS_UT_IDSIZE 4

struct exit_status
{
  short e_termination ;
  short e_exit ;
} ;

struct utmpx
{
  short ut_type ;
  pid_t ut_pid ;
  char ut_line[UTMPS_UT_LINESIZE] __attribute__((nonstring)) ;
  char ut_id[UTMPS_UT_IDSIZE] __attribute__((nonstring)) ;
  char ut_user[UTMPS_UT_NAMESIZE] __attribute__((nonstring)) ;

  char ut_host[UTMPS_UT_HOSTSIZE] __attribute__((nonstring)) ;
  struct exit_status ut_exit ;
  pid_t ut_session ;

  struct timeval ut_tv ;

  uint32_t ut_addr_v6[4] ;
  char _dummy[20] __attribute__((nonstring)) ;
} ;

#define EMPTY 0
#define BOOT_TIME 2
#define OLD_TIME 4
#define NEW_TIME 3
#define USER_PROCESS 7
#define INIT_PROCESS 5
#define LOGIN_PROCESS 6
#define DEAD_PROCESS 8

#define RUN_LVL 1
#define ACCOUNTING 9

extern void endutxent (void) ;
extern void setutxent (void) ;
extern struct utmpx *getutxent (void) ;
extern struct utmpx *getutxid (struct utmpx const *) ;
extern struct utmpx *getutxline (struct utmpx const *) ;
extern struct utmpx *pututxline (struct utmpx const *) ;

extern int utmpxname (char const *) ;
extern void updwtmpx (char const *, struct utmpx const *) ;
extern void logwtmp (char const *, char const *, char const *) ;

#define UT_LINESIZE UTMPS_UT_LINESIZE
#define UT_NAMESIZE UTMPS_UT_NAMESIZE
#define UT_HOSTSIZE UTMPS_UT_HOSTSIZE

/* Unused, but some packages (ex: procps-ng) require these macros to be present */
#define UTMPX_FILE "/run/utmps/utmp"
#define WTMPX_FILE "/var/log/wtmp"

/* More old GNU/crap compatibility */
#define ut_name ut_user
#define ut_xtime ut_tv.tv_sec
#define ut_addr ut_addr_v6[0]
#ifndef _NO_UT_TIME
# define ut_time ut_tv.tv_sec
#endif

#ifdef _DEFAULT_SOURCE
extern int utmps_getutxent_r (struct utmpx *, struct utmpx **) ;
extern int utmps_getutxid_r (struct utmpx const *, struct utmpx *, struct utmpx **) ;
extern int utmps_getutxent_r (struct utmpx const *, struct utmpx *, struct utmpx **) ;
#endif

#ifdef __cplusplus
}
#endif

#endif
