#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "You need to run as root or using sudo"
	exit 1
fi


s6-rc-update /etc/s6-rc/compiled-release
mv /etc/s6-rc/compiled-active /etc/s6-rc/compiled-superseded-$(date +%s%N)
rm -r /etc/s6-rc/compiled
s6-rc-compile /etc/s6-rc/compiled-active /etc/s6-rc/sv
ln -sf /etc/s6-rc/compiled-active /etc/s6-rc/compiled
s6-rc-update /etc/s6-rc/compiled
echo "s6-rc database has been updated"

while true
do
	read -p "Do you want to reload the new default service state? [Y/n] " choice01
	
	case $choice01 in
		[yY] ) echo  "reloading default bundle"; s6-rc start default; echo "default bundle has been reloaded"; break;;
		[nN] ) echo "leaving service state as-is"; break;;
		*) echo "Please select 'y' or 'n'"
	esac
done

while true
do
	read -p "Dou you want to delete old service databases? [Y/n] " choice02
	
	case $choice02 in
		[yY] ) echo  "Deleting all /etc/s6-rc/compiled-superseded* folders"; rm -rf /etc/s6-rc/compiled-superseded*; echo "Old service databases deleted"; break;;
		[nN] ) echo "Not deleting old service databases"; break;;
		*) echo "Please select 'y' or 'n'"
	esac
done
