/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.values;

import genj.gedcom.GedcomConstants;
import genj.gedcom.values.EnumInterface;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

public class EnumOperations {
    public static String getDisplayValue(Enum codeElement, String key) {
        String displayList = NbBundle.getMessage(GedcomConstants.class, (String)(key + ".vals"));
        String[] list = displayList.split(",");
        if (codeElement.ordinal() >= list.length) {
            return codeElement.name();
        }
        String value = list[codeElement.ordinal()];
        if (value != null) {
            return value.trim();
        }
        return codeElement.name();
    }

    public static String getCodeValueFromString(String str, Enum[] values, String defaultCode) {
        for (Enum role : values) {
            String displayValue = ((EnumInterface)((Object)role)).getDisplayValue();
            if (!role.name().equals(str) && !displayValue.equals(str)) continue;
            return role.name();
        }
        return defaultCode;
    }

    public static String getDisplayValueFromCode(String code, Enum[] values) {
        for (Enum role : values) {
            if (!role.name().equals(code)) continue;
            return ((EnumInterface)((Object)role)).getDisplayValue();
        }
        return "";
    }

    public static String getDisplayEventValue(Enum codeElement) {
        String value = NbBundle.getMessage(GedcomConstants.class, (String)(codeElement.name() + ".name"));
        if (value != null) {
            return value.trim();
        }
        return codeElement.name();
    }

    public static String[] getDisplayChoices(Enum[] values) {
        String[] ret = new String[values.length];
        int i = 0;
        for (Enum code : values) {
            ret[i++] = ((EnumInterface)((Object)code)).getDisplayValue();
        }
        return ret;
    }

    public static List<String> getCodeChoices(Enum[] values) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Enum code : values) {
            ret.add(code.name());
        }
        return ret;
    }
}

