/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Widget;

public final class RectangularAnchor
extends Anchor {
    private boolean includeBorders;

    public RectangularAnchor(Widget widget, boolean includeBorders) {
        super(widget);
        this.includeBorders = includeBorders;
    }

    @Override
    public boolean allowsArbitraryConnectionPlacement() {
        return false;
    }

    @Override
    public List<Point> compute(List<Point> points) {
        ArrayList<Point> bestPoints = new ArrayList<Point>(points);
        Point relatedLocation = this.getRelatedSceneLocation();
        int direction = 1;
        int index = 0;
        Point endPoint = bestPoints.get(index);
        if (!endPoint.equals(relatedLocation)) {
            index = bestPoints.size() - 1;
            endPoint = bestPoints.get(index);
            direction = -1;
        }
        Widget widget = this.getRelatedWidget();
        Rectangle bounds = widget.getBounds();
        bounds = widget.convertLocalToScene(bounds);
        Point neighbor = bestPoints.get(index + direction);
        while (bounds.contains(neighbor)) {
            bestPoints.remove(index);
            endPoint = bestPoints.get(index);
            neighbor = bestPoints.get(index + direction);
        }
        Anchor.Result intersection = this.computeBoundaryIntersectionPoint(endPoint, neighbor);
        bestPoints.remove(index);
        bestPoints.add(index, intersection.getAnchorSceneLocation());
        return bestPoints;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        Anchor.Result boundaryIntersection;
        Point relatedLocation = this.getRelatedSceneLocation();
        Point oppositeLocation = null;
        if (oppositeLocation == null) {
            oppositeLocation = this.getOppositeSceneLocation(entry);
        }
        if ((boundaryIntersection = this.computeBoundaryIntersectionPoint(relatedLocation, oppositeLocation)) == null) {
            return (Anchor)this.new Anchor.Result(relatedLocation, Anchor.DIRECTION_ANY);
        }
        return boundaryIntersection;
    }

    private Anchor.Result computeBoundaryIntersectionPoint(Point relatedLocation, Point oppositeLocation) {
        float ddy;
        Widget widget = this.getRelatedWidget();
        Rectangle bounds = widget.getBounds();
        if (!this.includeBorders) {
            Insets insets = widget.getBorder().getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        if ((bounds = widget.convertLocalToScene(bounds)).isEmpty() || relatedLocation.equals(oppositeLocation)) {
            return null;
        }
        float dx = oppositeLocation.x - relatedLocation.x;
        float dy = oppositeLocation.y - relatedLocation.y;
        float ddx = Math.abs(dx) / (float)bounds.width;
        Anchor.Direction direction = ddx >= (ddy = Math.abs(dy) / (float)bounds.height) ? (dx >= 0.0f ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT) : (dy >= 0.0f ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP);
        float scale = 0.5f / Math.max(ddx, ddy);
        Point point = new Point(Math.round((float)relatedLocation.x + scale * dx), Math.round((float)relatedLocation.y + scale * dy));
        return (Anchor)this.new Anchor.Result(point, direction);
    }
}

