/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.api.search.SearchCommunicator;
import ancestris.reports.ScopeOptions;
import ancestris.reports.relatives.ReportRelatives;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.NbBundle;

public class ScopeIndiOptions
extends ScopeOptions {
    public int scopeType = 0;
    public String[] scopeTypes = this.getScopes();
    public int chosenIndi = 0;
    public String[] chosenIndis = this.getReferences();
    public int nbgen = 0;
    public int livingInYear = Year.now().getValue();
    public boolean include_spouse = false;
    public boolean include_siblings = false;

    @Override
    public List<String[]> getMessages() {
        List<String[]> ret = super.getMessages();
        if (this.scopeType == 2 || this.scopeType == 3 || this.scopeType == 4) {
            ret.add(new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"nbgen"), this.nbgen == 0 ? NbBundle.getMessage(ScopeOptions.class, (String)"nbgenAll") : String.valueOf(this.nbgen)});
        }
        ret.add(new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"include_spouse"), NbBundle.getMessage(ScopeOptions.class, (String)String.valueOf(this.include_spouse))});
        ret.add(new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"include_siblings"), NbBundle.getMessage(ScopeOptions.class, (String)String.valueOf(this.include_siblings))});
        return ret;
    }

    public List<Indi> getScope(Object context, Report report) {
        Object fam;
        Object o = this.setRootEntity(context, "INDI", report, this.chosenIndi, this.scopeType, this.livingInYear);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List list = (List)o;
            return list;
        }
        Entity entity = this.getRootEntity();
        HashSet<Object> indis = new HashSet<Object>();
        Indi selectedHusb = null;
        Indi selectedWife = null;
        if (entity instanceof Indi) {
            Indi indi;
            selectedHusb = indi = (Indi)entity;
            selectedWife = indi;
        } else if (entity instanceof Fam) {
            fam = (Fam)entity;
            Indi indi = fam.getHusband();
            Indi wife = fam.getWife();
            if (indi != null) {
                selectedHusb = indi;
            }
            if (wife != null) {
                selectedWife = wife;
            }
        }
        if (selectedHusb == null && selectedWife != null) {
            selectedHusb = selectedWife;
        }
        if (selectedHusb != null && selectedWife == null) {
            selectedWife = selectedHusb;
        }
        if (selectedHusb == null && selectedWife == null) {
            selectedWife = selectedHusb = this.gedcom.getDeCujusIndi();
        }
        if (selectedHusb == null && selectedWife == null) {
            selectedWife = selectedHusb = (Indi)this.gedcom.getFirstEntity("INDI");
        }
        if (this.hasReference()) {
            indis.add(selectedHusb);
            indis.add(selectedWife);
        }
        if (this.scopeType == 5) {
            indis.addAll(new ReportRelatives().getRelatives(selectedHusb));
            if (selectedHusb != selectedWife) {
                indis.addAll(new ReportRelatives().getRelatives(selectedWife));
            }
        } else if (this.scopeType != 1) {
            if (this.scopeType == 7) {
                List ents = SearchCommunicator.getResultEntities((Gedcom)this.gedcom);
                fam = ents.iterator();
                while (fam.hasNext()) {
                    Entity entity2 = (Entity)fam.next();
                    if (!(entity2 instanceof Indi)) continue;
                    Indi resultIndi = (Indi)entity2;
                    indis.add(resultIndi);
                }
            } else if (!this.hasReference()) {
                for (Indi person : this.gedcom.getIndis()) {
                    if (this.scopeType == 6 && (this.areContemporaries((Entity)person, selectedHusb) || this.areContemporaries((Entity)person, selectedWife))) {
                        indis.add(person);
                    }
                    if (this.scopeType != 8 || !this.isAliveIn((Entity)person, this.livingInYear) && !this.isAliveIn((Entity)person, this.livingInYear)) continue;
                    indis.add(person);
                }
            } else if (this.scopeType == 2) {
                Set<Indi> descendants = this.getDescendantIndis(selectedHusb, selectedWife, this.nbgen);
                indis.addAll(descendants);
            } else if (this.scopeType == 3) {
                HashSet<Indi> ancestors = new HashSet<Indi>();
                ancestors.addAll(this.getAncestorIndis(selectedHusb, this.nbgen));
                if (selectedWife != selectedHusb) {
                    ancestors.addAll(this.getAncestorIndis(selectedWife, this.nbgen));
                }
                indis.addAll(ancestors);
            } else if (this.scopeType == 4) {
                Set<Indi> treeindis = this.getDescendantIndis(selectedHusb, selectedWife, this.nbgen);
                treeindis.addAll(this.getAncestorIndis(selectedHusb, this.nbgen));
                if (selectedWife != selectedHusb) {
                    treeindis.addAll(this.getAncestorIndis(selectedWife, this.nbgen));
                }
                indis.addAll(treeindis);
            }
        }
        if (this.include_spouse || this.include_siblings) {
            HashSet<Indi> spousesOrSiblings = new HashSet<Indi>();
            for (Indi indi : indis) {
                spousesOrSiblings.addAll(this.getSpouseAndSiblings(indi));
            }
            indis.addAll(spousesOrSiblings);
        }
        return new ArrayList<Indi>(indis);
    }

    private Set<Indi> getSpouseAndSiblings(Indi person) {
        HashSet<Indi> ret = new HashSet<Indi>();
        if (this.include_spouse) {
            for (Fam fam : person.getFamiliesWhereSpouse(true)) {
                Indi spouse = fam.getOtherSpouse(person);
                if (spouse == null) continue;
                ret.add(spouse);
            }
        }
        if (this.include_siblings) {
            for (Fam fam : person.getFamiliesWhereChild()) {
                ret.addAll(Arrays.asList(fam.getChildren(true)));
            }
        }
        return ret;
    }

    private Set<Indi> getAncestorIndis(Indi selectedHusb, int nbgen) {
        HashSet<Indi> ancestors = new HashSet<Indi>();
        this.addParents(selectedHusb, ancestors, 1, nbgen);
        return ancestors;
    }

    private void addParents(Indi indi, Set<Indi> ancestors, int i, int nbgen) {
        if (nbgen != 0 && i > nbgen) {
            return;
        }
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (famc != null) {
            Indi mother;
            Indi father = famc.getHusband();
            if (father != null) {
                ancestors.add(father);
                this.addParents(father, ancestors, i + 1, nbgen);
            }
            if ((mother = famc.getWife()) != null) {
                ancestors.add(mother);
                this.addParents(mother, ancestors, i + 1, nbgen);
            }
        }
    }

    private Set<Indi> getDescendantIndis(Indi selectedHusb, Indi selectedWife, int nbgen) {
        HashSet<Indi> descendants = new HashSet<Indi>();
        for (Fam fam : selectedHusb.getFamiliesWhereSpouse()) {
            if (selectedHusb != selectedWife && !selectedWife.isSpouseIn(fam)) continue;
            this.addChildren(fam, descendants, 1, nbgen);
        }
        return descendants;
    }

    private void addChildren(Fam fam, Set<Indi> descendants, int i, int nbgen) {
        Indi[] children;
        if (nbgen != 0 && i > nbgen) {
            return;
        }
        descendants.addAll(Arrays.asList(fam.getChildren()));
        for (Indi child : children = fam.getChildren()) {
            for (Fam childfam : child.getFamiliesWhereSpouse()) {
                this.addChildren(childfam, descendants, i + 1, nbgen);
            }
        }
    }
}

