/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.testIntegration.GroovyTestFramework;

public final class SpockTestFramework
extends GroovyTestFramework
implements DumbAware {
    private static final ExternalLibraryDescriptor SPOCK_DESCRIPTOR = new ExternalLibraryDescriptor("org.spockframework", "spock-core");

    @Override
    @NotNull
    public String getName() {
        return "Spock";
    }

    @Override
    public String getLibraryPath() {
        return null;
    }

    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return SPOCK_DESCRIPTOR;
    }

    @Override
    @NotNull
    public String getDefaultSuperClass() {
        return "spock.lang.Specification";
    }

    @Override
    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock_SetUp_Method.groovy");
    }

    @Override
    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock cleanup Method.groovy");
    }

    @Override
    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock Test Method.groovy");
    }

    public boolean isTestMethod(PsiElement element, boolean checkAbstract) {
        if (element == null) {
            return false;
        }
        return (Boolean)SpockTestFramework.callWithAlternateResolver((Project)element.getProject(), () -> SpockUtils.isTestMethod(element), (Object)false);
    }

    @Override
    protected String getMarkerClassFQName() {
        return "spock.lang.Specification";
    }

    @Override
    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (clazz == null) {
            return false;
        }
        return (Boolean)SpockTestFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> clazz.getLanguage() == GroovyLanguage.INSTANCE && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"spock.lang.Specification"), (Object)false);
    }

    @Nullable
    private PsiMethod findSpecificMethod(@NotNull PsiClass clazz, String methodName) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(0);
        }
        return (PsiMethod)SpockTestFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (!this.isTestClass(clazz, false)) {
                return null;
            }
            for (PsiMethod method : clazz.findMethodsByName(methodName, false)) {
                if (!method.getParameterList().isEmpty()) continue;
                return method;
            }
            return null;
        }, null);
    }

    @Override
    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(1);
        }
        return this.findSpecificMethod(clazz, "setup");
    }

    @Override
    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(2);
        }
        return this.findSpecificMethod(clazz, "cleanup");
    }

    public boolean shouldRunSingleClassAsJUnit5(Project project, GlobalSearchScope scope) {
        return (Boolean)SpockTestFramework.callWithAlternateResolver((Project)project, () -> {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("spock.lang.Specification", scope);
            return aClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.junit.platform.commons.annotation.Testable", (int)0);
        }, (Object)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "clazz";
        objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockTestFramework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSpecificMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findSetUpMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findTearDownMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

