/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007J\u001c\u0010\r\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nH\u0007J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0005H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "<init>", "()V", "computeMaskFromModifierList", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "computeMask", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "computeMaskForSpecialFlags", "Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub$SpecialFlag;", "maskHasModifier", "mask", "modifierToken", "maskHasSpecialFlag", "flag", "maskHas", "flagIndex", "", "maskToString", "", "psi"})
@SourceDebugExtension(value={"SMAP\nModifierMaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierMaskUtils.kt\norg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class ModifierMaskUtils {
    @NotNull
    public static final ModifierMaskUtils INSTANCE;

    private ModifierMaskUtils() {
    }

    @JvmStatic
    public static final long computeMaskFromModifierList(@NotNull KtModifierList modifierList2) {
        Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
        return ModifierMaskUtils.computeMask(arg_0 -> ModifierMaskUtils.computeMaskFromModifierList$lambda$1(modifierList2, arg_0));
    }

    @JvmStatic
    public static final long computeMask(@NotNull Function1<? super KtModifierKeywordToken, Boolean> hasModifier) {
        Intrinsics.checkNotNullParameter(hasModifier, "hasModifier");
        long mask = 0L;
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        int n2 = ktModifierKeywordTokenArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int index = i2;
            KtModifierKeywordToken modifierKeywordToken = ktModifierKeywordTokenArray[i2];
            Intrinsics.checkNotNull(modifierKeywordToken);
            if (!hasModifier.invoke(modifierKeywordToken).booleanValue()) continue;
            mask |= 1L << index;
        }
        return mask;
    }

    public final long computeMaskForSpecialFlags(@NotNull Function1<? super KotlinModifierListStub.SpecialFlag, Boolean> hasModifier) {
        Intrinsics.checkNotNullParameter(hasModifier, "hasModifier");
        int specialFlagOffset = KtTokens.MODIFIER_KEYWORDS_ARRAY.length;
        long mask = 0L;
        Iterator iterator2 = ((Iterable)KotlinModifierListStub.SpecialFlag.getEntries()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            KotlinModifierListStub.SpecialFlag specialFlag = (KotlinModifierListStub.SpecialFlag)((Object)iterator2.next());
            if (!hasModifier.invoke(specialFlag).booleanValue()) continue;
            mask |= 1L << specialFlagOffset + index;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(long mask, @NotNull KtModifierKeywordToken modifierToken) {
        boolean bl;
        Intrinsics.checkNotNullParameter(modifierToken, "modifierToken");
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        int index = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        boolean bl2 = bl = index >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "All KtModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
            throw new AssertionError((Object)string);
        }
        return INSTANCE.maskHas(mask, index);
    }

    @JvmStatic
    public static final boolean maskHasSpecialFlag(long mask, @NotNull KotlinModifierListStub.SpecialFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        int specialFlagOffset = KtTokens.MODIFIER_KEYWORDS_ARRAY.length;
        return INSTANCE.maskHas(mask, specialFlagOffset + flag.ordinal());
    }

    private final boolean maskHas(long mask, int flagIndex) {
        return (mask & 1L << flagIndex) != 0L;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(long mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Ref.BooleanRef first = new Ref.BooleanRef();
        first.element = true;
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        for (KtModifierKeywordToken modifierKeyword : KtTokens.MODIFIER_KEYWORDS_ARRAY) {
            Intrinsics.checkNotNull(modifierKeyword);
            if (!ModifierMaskUtils.maskHasModifier(mask, modifierKeyword)) continue;
            String string = modifierKeyword.getValue();
            Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
            ModifierMaskUtils.maskToString$renderFlag(first, sb, string);
        }
        for (KotlinModifierListStub.SpecialFlag specialFlag : KotlinModifierListStub.SpecialFlag.getEntries()) {
            if (!ModifierMaskUtils.maskHasSpecialFlag(mask, specialFlag)) continue;
            ModifierMaskUtils.maskToString$renderFlag(first, sb, specialFlag.name());
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final boolean computeMaskFromModifierList$lambda$1(KtModifierList $modifierList, KtModifierKeywordToken it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $modifierList.hasModifier(it);
    }

    private static final void maskToString$renderFlag(Ref.BooleanRef first, StringBuilder sb, String value2) {
        if (first.element) {
            first.element = false;
        } else {
            sb.append(" ");
        }
        sb.append(value2);
    }

    static {
        boolean bl;
        INSTANCE = new ModifierMaskUtils();
        boolean bl2 = bl = KtTokens.MODIFIER_KEYWORDS_ARRAY.length + KotlinModifierListStub.SpecialFlag.getEntries().size() <= 64;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Current implementation depends on the ability to represent modifier list as bit mask";
            throw new AssertionError((Object)string);
        }
    }
}

