/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.DvcsBranchManager;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.git.shared.branch.GitInOutCountersInProject;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitRefType;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchInProgressListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitTagHolder;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardTreeModel;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import git4idea.ui.branch.dashboard.BranchesTreeModelBase;
import git4idea.ui.branch.dashboard.RefInfo;
import git4idea.ui.branch.dashboard.RefsCollection;
import git4idea.ui.branch.dashboard.TagInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H$J\b\u0010)\u001a\u00020'H\u0005J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013H\u0002J6\u0010,\u001a\u00020\u0013\"\b\b\u0000\u0010-*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H-0\u001e2\u0006\u0010+\u001a\u00020\u0013H\u0002J\b\u00102\u001a\u00020'H\u0002J\b\u00103\u001a\u00020'H\u0002J\b\u00104\u001a\u00020'H\u0002J \u00105\u001a\u00020'*\b\u0012\u0004\u0012\u000207062\f\u00108\u001a\b\u0012\u0004\u0012\u00020706H\u0002JJ\u00109\u001a\u00020'2\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020<\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001e0;2\u0018\u0010=\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001e\u0012\u0004\u0012\u00020'0;2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020'0?H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R+\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00138V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR;\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u001d\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006@"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeModelBase;", "Lgit4idea/ui/branch/dashboard/BranchesTreeModelBase;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeModel;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "refs", "Lgit4idea/ui/branch/dashboard/RefsCollection;", "getRefs$intellij_vcs_git", "()Lgit4idea/ui/branch/dashboard/RefsCollection;", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "", "getGroupingConfig", "()Ljava/util/Map;", "<set-?>", "showOnlyMy", "getShowOnlyMy", "()Z", "setShowOnlyMy", "(Z)V", "showOnlyMy$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootsToFilter", "getRootsToFilter", "()Ljava/util/Set;", "setRootsToFilter", "(Ljava/util/Set;)V", "rootsToFilter$delegate", "dispose", "", "refreshTree", "updateBranchesTree", "reloadBranches", "force", "updateIfChanged", "T", "Lgit4idea/ui/branch/dashboard/RefInfo;", "currentState", "", "newState", "updateBranchesIsFavoriteState", "updateBranchesIncomingOutgoingState", "updateBranchesIsMyState", "updateUnsureBranchesStateFrom", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "updateFromBranches", "calculateMyBranchesInBackground", "run", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "onFinished", "Lkotlin/Function0;", "intellij.vcs.git"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBranchesDashboardTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardTreeModel.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardTreeModelBase\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,298:1\n33#2,3:299\n33#2,3:302\n774#3:305\n865#3,2:306\n774#3:310\n865#3,2:311\n1761#3,3:313\n30#4,2:308\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardTreeModel.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardTreeModelBase\n*L\n115#1:299,3\n117#1:302,3\n197#1:305\n197#1:306,2\n248#1:310\n248#1:311,2\n227#1:313,3\n224#1:308,2\n*E\n"})
public abstract class BranchesDashboardTreeModelBase
extends BranchesTreeModelBase
implements BranchesDashboardTreeModel,
Disposable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final Project project;
    @NotNull
    private final RefsCollection refs;
    @NotNull
    private final Map<GroupingKey, Boolean> groupingConfig;
    @NotNull
    private final ReadWriteProperty showOnlyMy$delegate;
    @NotNull
    private final ReadWriteProperty rootsToFilter$delegate;

    /*
     * WARNING - void declaration
     */
    public BranchesDashboardTreeModelBase(@NotNull VcsLogData logData) {
        void $this$groupingConfig_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        this.logData = logData;
        Project project = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.refs = new RefsCollection(new HashSet(), new HashSet(), new HashSet());
        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(this.project);
        BranchesDashboardTreeModelBase branchesDashboardTreeModelBase = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GroupingKey.GROUPING_BY_DIRECTORY, (Object)$this$groupingConfig_u24lambda_u240.getBranchSettings().isGroupingEnabled(GroupingKey.GROUPING_BY_DIRECTORY)), TuplesKt.to((Object)GroupingKey.GROUPING_BY_REPOSITORY, (Object)$this$groupingConfig_u24lambda_u240.getBranchSettings().isGroupingEnabled(GroupingKey.GROUPING_BY_REPOSITORY))};
        branchesDashboardTreeModelBase.groupingConfig = MapsKt.toMutableMap((Map)MapsKt.hashMapOf((Pair[])pairArray));
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = false;
        boolean $i$f$observable = false;
        this.showOnlyMy$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ BranchesDashboardTreeModelBase this$0;
            {
                this.this$0 = branchesDashboardTreeModelBase;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue2) {
                void new_;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue2;
                boolean old = (Boolean)oldValue;
                boolean bl2 = false;
                if (old != new_) {
                    BranchesDashboardTreeModelBase.access$updateBranchesIsMyState(this.this$0);
                }
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = null;
        $i$f$observable = false;
        this.rootsToFilter$delegate = (ReadWriteProperty)new ObservableProperty<Set<? extends VirtualFile>>((Object)initialValue$iv, this){
            final /* synthetic */ BranchesDashboardTreeModelBase this$0;
            {
                this.this$0 = branchesDashboardTreeModelBase;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue2) {
                void new_;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Set set = (Set)newValue2;
                Set old = (Set)oldValue;
                boolean bl = false;
                if (new_ != null && old != null && !Intrinsics.areEqual((Object)old, (Object)new_)) {
                    this.this$0.updateBranchesTree();
                }
            }
        };
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DVCS_BRANCH_SETTINGS_CHANGED");
        messageBusConnection2.subscribe(topic, (Object)new DvcsBranchManager.DvcsBranchManagerListener(){

            public void branchFavoriteSettingsChanged() {
                ActionsKt.runInEdt$default(null, () -> 1.branchFavoriteSettingsChanged$lambda$0(this), (int)1, null);
            }

            public void branchGroupingSettingsChanged(GroupingKey key, boolean state2) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ActionsKt.runInEdt$default(null, () -> 1.branchGroupingSettingsChanged$lambda$1(this, key, state2), (int)1, null);
            }

            public void showTagsSettingsChanged(boolean state2) {
                ActionsKt.runInEdt$default(null, () -> 1.showTagsSettingsChanged$lambda$2(this), (int)1, null);
            }

            private static final Unit branchFavoriteSettingsChanged$lambda$0(BranchesDashboardTreeModelBase this$0) {
                this$0.updateBranchesIsFavoriteState();
                return Unit.INSTANCE;
            }

            private static final Unit branchGroupingSettingsChanged$lambda$1(BranchesDashboardTreeModelBase this$0, GroupingKey $key, boolean $state) {
                this$0.getGroupingConfig().put($key, $state);
                this$0.refreshTree();
                return Unit.INSTANCE;
            }

            private static final Unit showTagsSettingsChanged$lambda$2(BranchesDashboardTreeModelBase this$0) {
                this$0.updateBranchesTree();
                return Unit.INSTANCE;
            }
        });
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitTagHolder.Companion.getGIT_TAGS_LOADED(), arg_0 -> BranchesDashboardTreeModelBase._init_$lambda$4(this, arg_0));
        MessageBusConnection messageBusConnection3 = this.project.getMessageBus().connect((Disposable)this);
        Topic<GitBranchIncomingOutgoingManager.GitIncomingOutgoingListener> topic2 = GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GIT_INCOMING_OUTGOING_CHANGED");
        messageBusConnection3.subscribe(topic2, () -> BranchesDashboardTreeModelBase._init_$lambda$6(this));
        DataPackChangeListener changeListener = arg_0 -> BranchesDashboardTreeModelBase._init_$lambda$7(this, arg_0);
        this.logData.addDataPackChangeListener(changeListener);
        Disposer.register((Disposable)this, () -> BranchesDashboardTreeModelBase._init_$lambda$8(this, changeListener));
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitFetchInProgressListener.Companion.getTOPIC(), (Object)new GitFetchInProgressListener(){

            @Override
            public void fetchStarted() {
                ActionsKt.runInEdt$default(null, () -> 5.fetchStarted$lambda$0(this), (int)1, null);
            }

            @Override
            public void fetchFinished() {
                ActionsKt.runInEdt$default(null, () -> 5.fetchFinished$lambda$1(this), (int)1, null);
            }

            private static final Unit fetchStarted$lambda$0(BranchesDashboardTreeModelBase this$0) {
                this$0.startLoading();
                return Unit.INSTANCE;
            }

            private static final Unit fetchFinished$lambda$1(BranchesDashboardTreeModelBase this$0) {
                this$0.finishLoading();
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RefsCollection getRefs$intellij_vcs_git() {
        return this.refs;
    }

    @Override
    @NotNull
    public Map<GroupingKey, Boolean> getGroupingConfig() {
        return this.groupingConfig;
    }

    @Override
    public boolean getShowOnlyMy() {
        return (Boolean)this.showOnlyMy$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setShowOnlyMy(boolean bl) {
        this.showOnlyMy$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Nullable
    public final Set<VirtualFile> getRootsToFilter() {
        return (Set)this.rootsToFilter$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setRootsToFilter(@Nullable Set<? extends VirtualFile> set) {
        this.rootsToFilter$delegate.setValue((Object)this, $$delegatedProperties[1], set);
    }

    public void dispose() {
        this.refs.forEach((Function2<? super Collection<? extends RefInfo>, ? super GitRefType, Unit>)((Function2)BranchesDashboardTreeModelBase::dispose$lambda$9));
        this.setRootsToFilter(null);
    }

    protected abstract void refreshTree();

    @RequiresEdt
    protected final void updateBranchesTree() {
        boolean forceReload = Intrinsics.areEqual((Object)this.getGroupingConfig().get(GroupingKey.GROUPING_BY_REPOSITORY), (Object)true);
        boolean changed = this.reloadBranches(forceReload);
        if (changed) {
            if (this.getShowOnlyMy()) {
                this.updateBranchesIsMyState();
            } else {
                this.refreshTree();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean reloadBranches(boolean force) {
        this.startLoading();
        try {
            List list;
            List list2 = GitRepositoryManager.getInstance(this.project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRepositories(...)");
            List allRepositories = list2;
            Set<VirtualFile> rootsToFilter = this.getRootsToFilter();
            if (rootsToFilter == null) {
                list = allRepositories;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = allRepositories;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GitRepository it = (GitRepository)element$iv$iv;
                    boolean bl = false;
                    if (!rootsToFilter.contains(it.getRoot())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List repositories = list;
            Set<BranchInfo> newLocalBranches = BranchesDashboardUtil.INSTANCE.getLocalBranches(this.project, repositories);
            Set<BranchInfo> newRemoteBranches = BranchesDashboardUtil.INSTANCE.getRemoteBranches(this.project, repositories);
            Set<TagInfo> newTags = BranchesDashboardUtil.INSTANCE.getTags(this.project, repositories);
            boolean reloadedLocal = this.updateIfChanged(this.refs.getLocalBranches(), newLocalBranches, force);
            boolean reloadedRemote = this.updateIfChanged(this.refs.getRemoteBranches(), newRemoteBranches, force);
            boolean reloadedTags = this.updateIfChanged(this.refs.getTags(), newTags, force);
            boolean bl = reloadedLocal || reloadedRemote || reloadedTags;
            return bl;
        }
        finally {
            this.finishLoading();
        }
    }

    private final <T extends RefInfo> boolean updateIfChanged(Collection<T> currentState, Set<? extends T> newState, boolean force) {
        boolean bl;
        if (force || !Intrinsics.areEqual(newState, currentState)) {
            currentState.clear();
            currentState.addAll((Collection)newState);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void updateBranchesIsFavoriteState() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager $this$updateBranchesIsFavoriteState_u24lambda_u2413 = (GitBranchManager)((Object)object);
        boolean bl = false;
        this.refs.forEach((Function2<? super Collection<? extends RefInfo>, ? super GitRefType, Unit>)((Function2)(arg_0, arg_1) -> BranchesDashboardTreeModelBase.updateBranchesIsFavoriteState$lambda$13$lambda$12($this$updateBranchesIsFavoriteState_u24lambda_u2413, arg_0, arg_1)));
        this.refreshTree();
    }

    private final void updateBranchesIncomingOutgoingState() {
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
        GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
        for (BranchInfo localBranch : this.refs.getLocalBranches()) {
            GitInOutCountersInProject incomingOutgoing;
            Intrinsics.checkNotNullExpressionValue((Object)incomingOutgoingManager.getIncomingOutgoingState((Collection<GitRepository>)localBranch.getRepositories(), new GitLocalBranch(localBranch.getBranchName())), (String)"getIncomingOutgoingState(...)");
            localBranch.setIncomingOutgoingState(incomingOutgoing);
        }
        this.refreshTree();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateBranchesIsMyState() {
        void $this$filterTo$iv$iv;
        List allBranches = CollectionsKt.plus(this.refs.getLocalBranches(), (Iterable)this.refs.getRemoteBranches());
        Iterable $this$filter$iv = allBranches;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BranchInfo it = (BranchInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.isMy() == ThreeState.UNSURE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List branchesToCheck = (List)destination$iv$iv;
        this.startLoading();
        this.calculateMyBranchesInBackground((Function1<? super ProgressIndicator, ? extends Set<BranchInfo>>)((Function1)arg_0 -> BranchesDashboardTreeModelBase.updateBranchesIsMyState$lambda$15(this, branchesToCheck, arg_0)), (Function1<? super Set<BranchInfo>, Unit>)((Function1)arg_0 -> BranchesDashboardTreeModelBase.updateBranchesIsMyState$lambda$16(this, arg_0)), (Function0<Unit>)((Function0)() -> BranchesDashboardTreeModelBase.updateBranchesIsMyState$lambda$17(this)));
    }

    private final void updateUnsureBranchesStateFrom(Collection<BranchInfo> $this$updateUnsureBranchesStateFrom, Collection<BranchInfo> updateFromBranches) {
        if (updateFromBranches.isEmpty()) {
            return;
        }
        for (BranchInfo branch : $this$updateUnsureBranchesStateFrom) {
            if (branch.isMy() != ThreeState.UNSURE) continue;
            branch.setMy(updateFromBranches.contains(branch) ? ThreeState.YES : ThreeState.NO);
        }
    }

    private final void calculateMyBranchesInBackground(Function1<? super ProgressIndicator, ? extends Set<BranchInfo>> run2, Function1<? super Set<BranchInfo>, Unit> onSuccess, Function0<Unit> onFinished) {
        Ref.ObjectRef calculatedBranches = new Ref.ObjectRef();
        Project project = this.project;
        String string = GitBundle.message("action.Git.Show.My.Branches.description.calculating.branches.progress", new Object[0]);
        new Task.Backgroundable((Ref.ObjectRef<Set<BranchInfo>>)calculatedBranches, run2, onSuccess, onFinished, project, string){
            final /* synthetic */ Ref.ObjectRef<Set<BranchInfo>> $calculatedBranches;
            final /* synthetic */ Function1<ProgressIndicator, Set<BranchInfo>> $run;
            final /* synthetic */ Function1<Set<BranchInfo>, Unit> $onSuccess;
            final /* synthetic */ Function0<Unit> $onFinished;
            {
                this.$calculatedBranches = $calculatedBranches;
                this.$run = $run;
                this.$onSuccess = $onSuccess;
                this.$onFinished = $onFinished;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$calculatedBranches.element = this.$run.invoke((Object)indicator);
            }

            public void onSuccess() {
                Set branches = (Set)this.$calculatedBranches.element;
                if (branches != null) {
                    this.$onSuccess.invoke((Object)branches);
                }
            }

            public void onFinished() {
                this.$onFinished.invoke();
            }
        }.queue();
    }

    private static final Unit lambda$4$lambda$3(BranchesDashboardTreeModelBase this$0) {
        this$0.updateBranchesTree();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(BranchesDashboardTreeModelBase this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ActionsKt.runInEdt$default(null, () -> BranchesDashboardTreeModelBase.lambda$4$lambda$3(this$0), (int)1, null);
    }

    private static final Unit lambda$6$lambda$5(BranchesDashboardTreeModelBase this$0) {
        this$0.updateBranchesIncomingOutgoingState();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$6(BranchesDashboardTreeModelBase this$0) {
        ActionsKt.runInEdt$default(null, () -> BranchesDashboardTreeModelBase.lambda$6$lambda$5(this$0), (int)1, null);
    }

    private static final void _init_$lambda$7(BranchesDashboardTreeModelBase this$0, DataPack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBranchesTree();
    }

    private static final void _init_$lambda$8(BranchesDashboardTreeModelBase this$0, DataPackChangeListener $changeListener) {
        this$0.logData.removeDataPackChangeListener($changeListener);
    }

    private static final Unit dispose$lambda$9(Collection infos, GitRefType gitRefType) {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)gitRefType, (String)"<unused var>");
        infos.clear();
        return Unit.INSTANCE;
    }

    private static final Unit updateBranchesIsFavoriteState$lambda$13$lambda$12(GitBranchManager $this_with, Collection refs, GitRefType refType) {
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
        for (RefInfo ref : refs) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = ref.getRepositories();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        if (!$this_with.isFavorite(refType, it, ref.getRefName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean isFavorite = bl;
            ref.setFavorite(isFavorite);
        }
        return Unit.INSTANCE;
    }

    private static final Set updateBranchesIsMyState$lambda$15(BranchesDashboardTreeModelBase this$0, List $branchesToCheck, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return BranchesDashboardUtil.INSTANCE.checkIsMyBranchesSynchronously(this$0.logData, $branchesToCheck, indicator);
    }

    private static final Unit updateBranchesIsMyState$lambda$16(BranchesDashboardTreeModelBase this$0, Set branches) {
        Intrinsics.checkNotNullParameter((Object)branches, (String)"branches");
        this$0.updateUnsureBranchesStateFrom(this$0.refs.getLocalBranches(), branches);
        this$0.updateUnsureBranchesStateFrom(this$0.refs.getRemoteBranches(), branches);
        this$0.refreshTree();
        return Unit.INSTANCE;
    }

    private static final Unit updateBranchesIsMyState$lambda$17(BranchesDashboardTreeModelBase this$0) {
        this$0.finishLoading();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateBranchesIsMyState(BranchesDashboardTreeModelBase $this) {
        $this.updateBranchesIsMyState();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BranchesDashboardTreeModelBase.class, "showOnlyMy", "getShowOnlyMy()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BranchesDashboardTreeModelBase.class, "rootsToFilter", "getRootsToFilter()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

