/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public final class LoopExtractHelper {
    public static boolean extractLoops(Statement root) {
        boolean res;
        boolean bl = res = LoopExtractHelper.extractLoopsRec(root) != 0;
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static int extractLoopsRec(Statement stat) {
        boolean updated;
        boolean res = false;
        block0: do {
            updated = false;
            for (Statement st : stat.getStats()) {
                int extr = LoopExtractHelper.extractLoopsRec(st);
                res |= extr != 0;
                if (extr != 2) continue;
                updated = true;
                continue block0;
            }
        } while (updated);
        if (stat.type == Statement.StatementType.DO && LoopExtractHelper.extractLoop((DoStatement)stat)) {
            return 2;
        }
        return res ? 1 : 0;
    }

    private static boolean extractLoop(DoStatement stat) {
        if (stat.getLoopType() != DoStatement.LoopType.DO) {
            return false;
        }
        ArrayList<Statement> stats = new ArrayList<Statement>();
        for (StatEdge edge : stat.getLabelEdges()) {
            if (edge.getType() == StatEdge.EdgeType.CONTINUE || edge.getDestination().type == Statement.StatementType.DUMMY_EXIT) continue;
            if (edge.getType() == StatEdge.EdgeType.BREAK && LoopExtractHelper.isExternStatement(stat, edge.getSource(), edge.getSource())) {
                stats.add(edge.getSource());
                continue;
            }
            return false;
        }
        if (!stats.isEmpty() && stat.getParent().getStats().getLast() != stat) {
            return false;
        }
        if (!LoopExtractHelper.extractFirstIf(stat, stats)) {
            return LoopExtractHelper.extractLastIf(stat, stats);
        }
        return true;
    }

    private static boolean extractLastIf(DoStatement stat, List<Statement> stats) {
        Statement last = stat.getFirst();
        while (last.type == Statement.StatementType.SEQUENCE) {
            last = last.getStats().getLast();
        }
        if (last.type == Statement.StatementType.IF) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() != null) {
                Statement ifstat = lastif.getIfstat();
                StatEdge elseedge = lastif.getAllSuccessorEdges().get(0);
                if (elseedge.getType() == StatEdge.EdgeType.CONTINUE && elseedge.closure == stat) {
                    Set<Statement> set = stat.getNeighboursSet(StatEdge.EdgeType.CONTINUE, StatEdge.EdgeDirection.BACKWARD);
                    set.remove(last);
                    if (set.isEmpty() && LoopExtractHelper.isExternStatement(stat, ifstat, ifstat)) {
                        Statement first = stat.getFirst();
                        while (first.type == Statement.StatementType.SEQUENCE) {
                            first = first.getFirst();
                        }
                        if (first.type == Statement.StatementType.DO && ((DoStatement)first).getLoopType() == DoStatement.LoopType.DO) {
                            return false;
                        }
                        for (Statement s : stats) {
                            if (ifstat.containsStatement(s)) continue;
                            return false;
                        }
                        LoopExtractHelper.extractIfBlock(stat, lastif);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean extractFirstIf(DoStatement stat, List<Statement> stats) {
        Statement ifstat;
        IfStatement firstif;
        List<Exprent> exprents;
        Statement first = stat.getFirst();
        while (first.type == Statement.StatementType.SEQUENCE) {
            first = first.getFirst();
        }
        if (first.type == Statement.StatementType.IF && (exprents = (firstif = (IfStatement)first).getFirst().getExprents()) != null && exprents.isEmpty() && firstif.iftype == 0 && firstif.getIfstat() != null && LoopExtractHelper.isExternStatement(stat, ifstat = firstif.getIfstat(), ifstat)) {
            for (Statement s : stats) {
                if (ifstat.containsStatement(s)) continue;
                return false;
            }
            LoopExtractHelper.extractIfBlock(stat, firstif);
            return true;
        }
        return false;
    }

    private static boolean isExternStatement(DoStatement loop, Statement block, Statement stat) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (!loop.containsStatement(edge.getDestination()) || block.containsStatement(edge.getDestination())) continue;
            return false;
        }
        for (Statement st : stat.getStats()) {
            if (LoopExtractHelper.isExternStatement(loop, block, st)) continue;
            return false;
        }
        return true;
    }

    private static void extractIfBlock(DoStatement loop, IfStatement ifstat) {
        Statement target = ifstat.getIfstat();
        StatEdge ifedge = ifstat.getIfEdge();
        ifstat.setIfstat(null);
        ifedge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, ifedge, StatEdge.EdgeType.BREAK);
        ifedge.closure = loop;
        ifstat.getStats().removeWithKey(target.id);
        loop.addLabeledEdge(ifedge);
        SequenceStatement block = new SequenceStatement(Arrays.asList(loop, target));
        loop.getParent().replaceStatement(loop, block);
        block.setAllParent();
        loop.addSuccessor(new StatEdge(StatEdge.EdgeType.REGULAR, (Statement)loop, target));
        for (StatEdge edge : new ArrayList<StatEdge>(block.getLabelEdges())) {
            if (edge.getType() != StatEdge.EdgeType.CONTINUE && edge != ifedge) continue;
            loop.addLabeledEdge(edge);
        }
        for (StatEdge edge : block.getPredecessorEdges(StatEdge.EdgeType.CONTINUE)) {
            if (!loop.containsStatementStrict(edge.getSource())) continue;
            block.removePredecessor(edge);
            edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, loop);
            loop.addPredecessor(edge);
        }
        List<StatEdge> link = target.getPredecessorEdges(StatEdge.EdgeType.BREAK);
        if (link.size() == 1) {
            link.get((int)0).canInline = false;
        }
    }
}

