/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

class CoverageTableModel
extends AbstractTreeModel
implements TreeTableModel,
SortableColumnModel,
TreeModelListener,
TreeVisitor.Acceptor {
    private final ColumnInfo[] COLUMN_INFOS;
    private final AsyncTreeModel myAsyncModel;
    private final StructureTreeModel<CoverageViewTreeStructure> myStructureModel;
    private JTree myTree;

    CoverageTableModel(@NotNull CoverageSuitesBundle suitesBundle, Project project, CoverageViewTreeStructure structure) {
        if (suitesBundle == null) {
            CoverageTableModel.$$$reportNull$$$0(0);
        }
        CoverageEngine coverageEngine = suitesBundle.getCoverageEngine();
        this.COLUMN_INFOS = coverageEngine.createCoverageViewExtension(project, suitesBundle).createColumnInfos();
        this.myStructureModel = new StructureTreeModel((AbstractTreeStructure)structure, (Disposable)this);
        this.myAsyncModel = new AsyncTreeModel(this.myStructureModel, true, (Disposable)this);
        this.myAsyncModel.addTreeModelListener((TreeModelListener)this);
    }

    public void reset(boolean restorePaths) {
        if (restorePaths) {
            this.runActionWithPathsRestore(() -> this.myStructureModel.invalidateAsync());
        } else {
            this.myStructureModel.invalidateAsync();
        }
    }

    public void setComparator(Comparator<? super NodeDescriptor<?>> comparator) {
        this.runActionWithPathsRestore(() -> this.myStructureModel.setComparator(comparator));
    }

    public void runActionWithPathsRestore(Runnable action) {
        ApplicationManager.getApplication().invokeLater(() -> {
            List selectedPaths = TreeUtil.collectSelectedPaths((JTree)this.myTree);
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)this.myTree);
            action.run();
            for (TreePath path : selectedPaths) {
                TreeUtil.promiseSelect((JTree)this.myTree, (TreePath)path);
            }
            for (TreePath path : expandedPaths) {
                TreeUtil.promiseExpand((JTree)this.myTree, (TreePath)path);
            }
        });
    }

    public Object getRoot() {
        return this.myAsyncModel.getRoot();
    }

    public Object getChild(Object parent, int index) {
        return this.myAsyncModel.getChild(parent, index);
    }

    public int getChildCount(Object parent) {
        return this.myAsyncModel.getChildCount(parent);
    }

    public boolean isLeaf(Object node) {
        return this.myAsyncModel.isLeaf(node);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.myAsyncModel.getIndexOfChild(parent, child);
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            CoverageTableModel.$$$reportNull$$$0(1);
        }
        Promise promise = this.myAsyncModel.accept(visitor);
        if (promise == null) {
            CoverageTableModel.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
        this.myTree = tree;
    }

    public int getColumnCount() {
        return this.COLUMN_INFOS.length;
    }

    public String getColumnName(int column) {
        return this.COLUMN_INFOS[column].getName();
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return this.COLUMN_INFOS[column].getColumnClass();
    }

    public Object getValueAt(Object node, int column) {
        AbstractTreeNode<?> coverageNode = this.getCoverageNode(node);
        if (coverageNode != null) {
            return this.COLUMN_INFOS[column].valueOf(coverageNode);
        }
        return "";
    }

    public AbstractTreeNode<?> getCoverageNode(Object node) {
        DefaultMutableTreeNode mutableTreeNode;
        Object object;
        if (node instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)node;
            return treeNode;
        }
        if (node instanceof DefaultMutableTreeNode && (object = (mutableTreeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)object;
            return treeNode;
        }
        return null;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.COLUMN_INFOS;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    public Object getRowValue(int row) {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getPathForRow(row);
        if (path == null) {
            return null;
        }
        return path.getLastPathComponent();
    }

    @Nullable
    public RowSorter.SortKey getDefaultSortKey() {
        return null;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.treeNodesChanged(e.getTreePath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.treeNodesInserted(e.getTreePath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.treeNodesRemoved(e.getTreePath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.treeStructureChanged(e.getTreePath(), e.getChildIndices(), e.getChildren());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitesBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

