/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;

public final class CopySpecWalker {
    private static Collection<Object> getSourcePaths(Object object) {
        MetaClass metaClass = DefaultGroovyMethods.getMetaClass((Object)object);
        List getSourcePaths = metaClass.respondsTo(object, "getSourcePaths");
        if (!getSourcePaths.isEmpty()) {
            return (Collection)((MetaMethod)getSourcePaths.get(0)).invoke(object, new Object[0]);
        }
        if (metaClass.hasProperty(object, "sourcePaths") != null) {
            return (Collection)metaClass.getProperty(object, "sourcePaths");
        }
        return null;
    }

    @ApiStatus.Internal
    public static void walk(CopySpec copySpec, final Visitor visitor) {
        copySpec.setIncludeEmptyDirs(true);
        MetaClass copySpecMetaclass = DefaultGroovyMethods.getMetaClass((Object)copySpec);
        List walkMethods = copySpecMetaclass.respondsTo((Object)copySpec, "walk", new Object[]{Action.class});
        if (walkMethods.isEmpty()) {
            return;
        }
        ((MetaMethod)walkMethods.get(0)).invoke((Object)copySpec, new Object[]{new Action<Object>(){

            public void execute(Object resolver) {
                MetaClass resolverMetaclass = DefaultGroovyMethods.getMetaClass((Object)resolver);
                List setIncludeEmptyDirs = resolverMetaclass.respondsTo(resolver, "setIncludeEmptyDirs", new Object[]{Boolean.class});
                if (!setIncludeEmptyDirs.isEmpty()) {
                    ((MetaMethod)setIncludeEmptyDirs.get(0)).invoke(resolver, new Object[]{true});
                }
                if (resolverMetaclass.respondsTo(resolver, "getDestPath").isEmpty() || resolverMetaclass.respondsTo(resolver, "getSource").isEmpty()) {
                    throw new RuntimeException(GradleVersion.current() + " is not supported by JEE artifact importer");
                }
                Object destPath = ((MetaMethod)resolverMetaclass.respondsTo(resolver, "getDestPath").get(0)).invoke(resolver, new Object[0]);
                final String relativePath = (String)GradleReflectionUtil.getValue((Object)destPath, (String)"getPathString", String.class);
                Collection sourcePaths = CopySpecWalker.getSourcePaths(resolver);
                if (sourcePaths == null) {
                    Iterator this0 = resolverMetaclass.getProperty(resolver, "this$0");
                    sourcePaths = CopySpecWalker.getSourcePaths(this0);
                }
                if (sourcePaths != null) {
                    for (Object path : DefaultGroovyMethods.flatten((Collection)sourcePaths)) {
                        if (!(path instanceof String)) continue;
                        visitor.visitSourcePath(relativePath, (String)path);
                    }
                }
                FileTree sourceTree = (FileTree)GradleReflectionUtil.getValue((Object)resolver, (String)"getSource", FileTree.class);
                sourceTree.visit(new FileVisitor(){

                    public void visitDir(FileVisitDetails dirDetails) {
                        try {
                            visitor.visitDir(relativePath, dirDetails);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void visitFile(FileVisitDetails fileDetails) {
                        try {
                            visitor.visitFile(relativePath, fileDetails);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }});
    }

    public static interface Visitor {
        public void visitSourcePath(String var1, String var2);

        public void visitDir(String var1, FileVisitDetails var2);

        public void visitFile(String var1, FileVisitDetails var2);
    }
}

