/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.tree;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.tree.RunDashboardGroupImpl;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FolderDashboardGroupingRule
implements RunDashboardGroupingRule {
    @NonNls
    private static final String NAME = "FolderDashboardGroupingRule";

    @NotNull
    public String getName() {
        return NAME;
    }

    @Nullable
    public RunDashboardGroup getGroup(AbstractTreeNode<?> node) {
        RunnerAndConfigurationSettings configurationSettings;
        String folderName;
        if (node instanceof RunDashboardRunConfigurationNode && (folderName = (configurationSettings = ((RunDashboardRunConfigurationNode)node).getConfigurationSettings()).getFolderName()) != null) {
            return new FolderDashboardGroup(node.getProject(), folderName, folderName, AllIcons.Nodes.Folder);
        }
        return null;
    }

    public static final class FolderDashboardGroup
    extends RunDashboardGroupImpl<String> {
        private final Project myProject;

        public FolderDashboardGroup(Project project, String value, String name, Icon icon) {
            super(value, name, icon);
            this.myProject = project;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

