/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnRepositoryBinaryContentRevision;

public class SvnRepositoryContentRevision
extends SvnBaseContentRevision
implements ByteBackedContentRevision {
    @NotNull
    private final String myPath;
    private final long myRevision;

    public SvnRepositoryContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(0);
        }
        if (remotePath == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(1);
        }
        super(vcs, (FilePath)ObjectUtils.notNull((Object)localPath, (Object)remotePath));
        this.myPath = FileUtil.toSystemIndependentName((String)remotePath.getPath());
        this.myRevision = revision;
    }

    @NotNull
    public String getContent() throws VcsException {
        String string = ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.myFile, null);
        if (string == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(2);
        }
        return string;
    }

    public byte @NotNull [] getContentAsBytes() throws VcsException {
        byte[] byArray;
        try {
            if (this.myFile.getVirtualFile() == null) {
                LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myFile.getPath());
            }
            byArray = ContentRevisionCache.getOrLoadAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, () -> this.loadContent().toByteArray());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        if (byArray == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    @NotNull
    protected ByteArrayOutputStream loadContent() throws VcsException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myPath, buffer, this.myRevision);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, null);
        } else {
            loader.run();
        }
        Exception exception = loader.getException();
        if (exception != null) {
            throw new VcsException((Throwable)exception);
        }
        ContentRevisionCache.checkContentsSize((String)this.myPath, (long)buffer.size());
        ByteArrayOutputStream byteArrayOutputStream = buffer;
        if (byteArrayOutputStream == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(4);
        }
        return byteArrayOutputStream;
    }

    @NotNull
    public SvnRevisionNumber getRevisionNumber() {
        return new SvnRevisionNumber(Revision.of(this.myRevision));
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(5);
        }
        if (repositoryRoot == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(6);
        }
        if (path == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(7);
        }
        return SvnRepositoryContentRevision.create(vcs, Url.append(repositoryRoot, path), localPath, revision);
    }

    public static SvnRepositoryContentRevision createForRemotePath(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, boolean isDirectory, long revision) {
        if (vcs == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(8);
        }
        if (repositoryRoot == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(9);
        }
        if (path == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(10);
        }
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)Url.append(repositoryRoot, path), (boolean)isDirectory);
        return SvnRepositoryContentRevision.create(vcs, remotePath, remotePath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String fullPath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(11);
        }
        if (fullPath == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(12);
        }
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)fullPath, (boolean)false);
        return SvnRepositoryContentRevision.create(vcs, remotePath, localPath == null ? remotePath : localPath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(13);
        }
        if (remotePath == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(14);
        }
        return remotePath.getFileType().isBinary() ? new SvnRepositoryBinaryContentRevision(vcs, remotePath, localPath, revision) : new SvnRepositoryContentRevision(vcs, remotePath, localPath, revision);
    }

    public String toString() {
        return String.valueOf(this.myFile.getIOFile()) + "#" + this.myRevision;
    }

    @NotNull
    public String getFullPath() {
        String string = this.myPath;
        if (string == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(15);
        }
        return string;
    }

    public String getRelativePath(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(16);
        }
        return SvnUtil.getRelativePath(repositoryUrl, this.myPath);
    }

    @NotNull
    public Url getUrl() throws SvnBindException {
        Url url = SvnUtil.createUrl(this.getFullPath(), false);
        if (url == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(17);
        }
        return url;
    }

    @NotNull
    public Target toTarget() throws SvnBindException {
        Target target = Target.on(this.getUrl(), this.getRevisionNumber().getRevision());
        if (target == null) {
            SvnRepositoryContentRevision.$$$reportNull$$$0(18);
        }
        return target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRoot";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsBytes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createForRemotePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 15, 17, 18 -> new IllegalStateException(string);
        };
    }

    private class ContentLoader
    implements Runnable {
        private final String myPath;
        private final long myRevision;
        private final OutputStream myDst;
        private Exception myException;

        ContentLoader(String path, OutputStream dst, long revision) {
            this.myPath = path;
            this.myDst = dst;
            this.myRevision = revision;
        }

        public Exception getException() {
            return this.myException;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myPath));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                Revision revision = Revision.of(this.myRevision);
                byte[] contents = SvnUtil.getFileContents(SvnRepositoryContentRevision.this.myVcs, Target.on(SvnRepositoryContentRevision.this.getUrl()), revision, revision);
                this.myDst.write(contents);
            }
            catch (VcsException | IOException e) {
                this.myException = e;
            }
        }
    }
}

