/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.testFramework.IndexWaiter;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil;", "", "<init>", "()V", "Companion", "intellij.platform.testFramework"})
public final class IndexingTestUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Duration DEFAULT_TIMEOUT;

    private IndexingTestUtil() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void waitUntilIndexesAreReadyInAllOpenedProjects(@NotNull Duration indexWaitingTimeout) {
        Companion.waitUntilIndexesAreReadyInAllOpenedProjects(indexWaitingTimeout);
    }

    @JvmStatic
    @JvmOverloads
    public static final void waitUntilIndexesAreReady(@NotNull Project project, @NotNull Duration indexWaitingTimeout) {
        Companion.waitUntilIndexesAreReady(project, indexWaitingTimeout);
    }

    @JvmStatic
    @JvmOverloads
    public static final void waitUntilIndexesAreReadyInAllOpenedProjects() {
        Companion.waitUntilIndexesAreReadyInAllOpenedProjects();
    }

    @JvmStatic
    @JvmOverloads
    public static final void waitUntilIndexesAreReady(@NotNull Project project) {
        Companion.waitUntilIndexesAreReady(project);
    }

    static {
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        DEFAULT_TIMEOUT = duration;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0007J\u001a\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0007J\"\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\rH\u0086@\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil$Companion;", "", "<init>", "()V", "DEFAULT_TIMEOUT", "Ljava/time/Duration;", "waitUntilIndexesAreReadyInAllOpenedProjects", "", "indexWaitingTimeout", "waitUntilIndexesAreReady", "project", "Lcom/intellij/openapi/project/Project;", "suspendUntilIndexesAreReady", "Lkotlin/time/Duration;", "suspendUntilIndexesAreReady-8Mi8wO0", "(Lcom/intellij/openapi/project/Project;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "v", "", "forceSkipWaiting", "getForceSkipWaiting", "()Z", "setForceSkipWaiting", "(Z)V", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void waitUntilIndexesAreReadyInAllOpenedProjects(@NotNull Duration indexWaitingTimeout) {
            Intrinsics.checkNotNullParameter((Object)indexWaitingTimeout, (String)"indexWaitingTimeout");
            if (this.getForceSkipWaiting()) {
                return;
            }
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                new IndexWaiter(project).waitUntilFinished(indexWaitingTimeout);
            }
        }

        public static /* synthetic */ void waitUntilIndexesAreReadyInAllOpenedProjects$default(Companion companion, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                duration = DEFAULT_TIMEOUT;
            }
            companion.waitUntilIndexesAreReadyInAllOpenedProjects(duration);
        }

        @JvmStatic
        @JvmOverloads
        public final void waitUntilIndexesAreReady(@NotNull Project project, @NotNull Duration indexWaitingTimeout) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indexWaitingTimeout, (String)"indexWaitingTimeout");
            if (this.getForceSkipWaiting()) {
                return;
            }
            new IndexWaiter(project).waitUntilFinished(indexWaitingTimeout);
        }

        public static /* synthetic */ void waitUntilIndexesAreReady$default(Companion companion, Project project, Duration duration, int n, Object object) {
            if ((n & 2) != 0) {
                duration = DEFAULT_TIMEOUT;
            }
            companion.waitUntilIndexesAreReady(project, duration);
        }

        @Nullable
        public final Object suspendUntilIndexesAreReady-8Mi8wO0(@NotNull Project project, long indexWaitingTimeout, @NotNull Continuation<? super Unit> $completion) {
            if (this.getForceSkipWaiting()) {
                return Unit.INSTANCE;
            }
            IndexWaiter indexWaiter = new IndexWaiter(project);
            long l = indexWaitingTimeout;
            int n = kotlin.time.Duration.getNanosecondsComponent-impl((long)l);
            long l2 = kotlin.time.Duration.getInWholeSeconds-impl((long)l);
            Duration duration = Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
            Object object = indexWaiter.suspendUntilIndexesAreReady(duration, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static /* synthetic */ Object suspendUntilIndexesAreReady-8Mi8wO0$default(Companion companion, Project project, long l, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                Duration duration = DEFAULT_TIMEOUT;
                l = kotlin.time.Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
            }
            return companion.suspendUntilIndexesAreReady-8Mi8wO0(project, l, (Continuation<? super Unit>)continuation);
        }

        public final boolean getForceSkipWaiting() {
            return Boolean.parseBoolean(System.getProperty("IndexingTestUtil.force.skip.waiting", "false"));
        }

        public final void setForceSkipWaiting(boolean v) {
            System.setProperty("IndexingTestUtil.force.skip.waiting", String.valueOf(v));
        }

        @JvmStatic
        @JvmOverloads
        public final void waitUntilIndexesAreReadyInAllOpenedProjects() {
            com.intellij.testFramework.IndexingTestUtil$Companion.waitUntilIndexesAreReadyInAllOpenedProjects$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void waitUntilIndexesAreReady(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.intellij.testFramework.IndexingTestUtil$Companion.waitUntilIndexesAreReady$default(this, project, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

