/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInsight.intention.choice.DefaultIntentionActionWithChoice;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0003\u001b\u001c\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u00060\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo;", "Lcom/intellij/codeInsight/intention/choice/DefaultIntentionActionWithChoice;", "Lcom/intellij/spellchecker/quickfixes/LazySuggestions;", "typo", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "getVariants", "", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "removeHighlightersWithExactRange", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/Segment;", "Companion", "ChangeToTitleAction", "ChangeToVariantAction", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nChangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1563#2:116\n1634#2,3:117\n*S KotlinDebug\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n*L\n92#1:116\n92#1:117,3\n*E\n"})
public final class ChangeTo
extends LazySuggestions
implements DefaultIntentionActionWithChoice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange range;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;
    @NotNull
    private static final Lazy<String> fixName$delegate = LazyKt.lazy(ChangeTo::fixName_delegate$lambda$1);

    public ChangeTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(typo);
        this.range = range;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.pointer = smartPsiElementPointer;
    }

    @NotNull
    public ChoiceTitleIntentionAction getTitle() {
        return ChangeToTitleAction.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChoiceVariantIntentionAction> getVariants() {
        void $this$mapTo$iv$iv;
        int limit = Registry.Companion.intValue("spellchecker.corrections.limit");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChangeToVariantAction((int)it));
        }
        return (List)destination$iv$iv;
    }

    public final void removeHighlightersWithExactRange(@NotNull Document document, @NotNull Project project, @NotNull Segment range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false);
        if (markupModel == null) {
            return;
        }
        MarkupModel model = markupModel;
        for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            RangeHighlighter highlighter = rangeHighlighter;
            if (!TextRange.areSegmentsEqual((Segment)range, (Segment)((Segment)highlighter))) continue;
            model.removeHighlighter(highlighter);
        }
    }

    private static final String fixName_delegate$lambda$1() {
        return SpellCheckerBundle.message("change.to.title", new Object[0]);
    }

    @NotNull
    public static final String getFixName() {
        return Companion.getFixName();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "intellij.spellchecker"})
    private static final class ChangeToTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction,
    DumbAware {
        @NotNull
        public static final ChangeToTitleAction INSTANCE = new ChangeToTitleAction();

        private ChangeToTitleAction() {
            super(Companion.getFixName(), Companion.getFixName());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "index", "", "<init>", "(Lcom/intellij/spellchecker/quickfixes/ChangeTo;I)V", "getIndex", "()I", "suggestion", "", "getName", "getTooltipText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "applyFix", "", "getRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "startInWriteAction", "intellij.spellchecker"})
    private class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction {
        private final int index;
        @NlsSafe
        @Nullable
        private String suggestion;

        public ChangeToVariantAction(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @NotNull
        public String getName() {
            String string = this.suggestion;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public String getTooltipText() {
            Object[] objectArray = new Object[]{this.getName()};
            return SpellCheckerBundle.message("change.to.tooltip", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return Companion.getFixName();
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            List<String> list = ChangeTo.this.getSuggestions(project);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
            List<String> suggestions = list;
            if (suggestions.size() <= this.getIndex()) {
                return false;
            }
            Document document = psiFile.getViewProvider().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            if (this.getRange(document) == null) {
                return false;
            }
            this.suggestion = suggestions.get(this.getIndex());
            return true;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            String string = this.suggestion;
            if (string == null) {
                return;
            }
            String suggestion = string;
            Document document = psiFile.getViewProvider().getDocument();
            Intrinsics.checkNotNull((Object)document);
            TextRange textRange = this.getRange(document);
            if (textRange == null) {
                return;
            }
            TextRange myRange = textRange;
            ChangeTo.this.removeHighlightersWithExactRange(document, project, (Segment)myRange);
            document.replaceString(myRange.getStartOffset(), myRange.getEndOffset(), (CharSequence)suggestion);
        }

        private final TextRange getRange(Document document) {
            PsiElement psiElement = ChangeTo.this.pointer.getElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            TextRange textRange = ChangeTo.this.range.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange range = textRange;
            if (range.getStartOffset() < 0 || range.getEndOffset() > document.getTextLength()) {
                return null;
            }
            String string = document.getText(range);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            if (!Intrinsics.areEqual((Object)text, (Object)ChangeTo.this.typo)) {
                return null;
            }
            return range;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return (FileModifier)this;
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$Companion;", "", "<init>", "()V", "fixName", "", "getFixName$annotations", "getFixName", "()Ljava/lang/String;", "fixName$delegate", "Lkotlin/Lazy;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFixName() {
            Lazy lazy = fixName$delegate;
            return (String)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getFixName$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

