/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelExecApiHelpers;
import com.intellij.platform.eel.EelExecApiHelpersKt;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.ExecuteProcessException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtil;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a:\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0019\u001a\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a0\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0082@\u00a2\u0006\u0002\u0010\u001f\u001a\u0018\u0010 \u001a\u0004\u0018\u00010\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001aH\u0010!\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\"\u001a\b\u0010#\u001a\u00020\u001bH\u0000\"\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"initStartupMomentIfNeeded", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions$Builder;", "logCommonStartupInfo", "", "connector", "Lcom/jediterm/terminal/TtyConnector;", "process", "Ljava/lang/Process;", "durationBetweenStartupAndComponentResized", "Ljava/time/Duration;", "durationBetweenStartupAndConnectorCreated", "startProcess", "Lcom/pty4j/PtyProcess;", "command", "", "", "envs", "", "initialWorkingDirectory", "Ljava/nio/file/Path;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "convertCommandToRemote", "eelApi", "Lcom/intellij/platform/eel/EelApi;", "(Lcom/intellij/platform/eel/EelApi;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isWslCommand", "", "getEelApi", "Lkotlin/Pair;", "workingDirectory", "(Ljava/nio/file/Path;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWslDistributionNameFromCommand", "doStartProcess", "(Lcom/intellij/platform/eel/EelApi;Ljava/util/List;Ljava/util/Map;Ljava/nio/file/Path;Lcom/jediterm/core/util/TermSize;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldUseEelApi", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nterminalStartup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n1#2:133\n14#3:134\n*S KotlinDebug\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n*L\n131#1:134\n*E\n"})
public final class TerminalStartupKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final ShellStartupOptions.Builder initStartupMomentIfNeeded(@NotNull ShellStartupOptions.Builder $this$initStartupMomentIfNeeded) {
        ShellStartupOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$initStartupMomentIfNeeded, (String)"<this>");
        ShellStartupOptions.Builder $this$initStartupMomentIfNeeded_u24lambda_u240 = builder = $this$initStartupMomentIfNeeded;
        boolean bl = false;
        TerminalStartupMoment terminalStartupMoment = $this$initStartupMomentIfNeeded_u24lambda_u240.getStartupMoment$intellij_terminal();
        if (terminalStartupMoment == null) {
            terminalStartupMoment = new TerminalStartupMoment();
        }
        $this$initStartupMomentIfNeeded_u24lambda_u240.startupMoment(terminalStartupMoment);
        return builder;
    }

    public static final void logCommonStartupInfo(@NotNull TtyConnector connector, @NotNull Process process, @NotNull Duration durationBetweenStartupAndComponentResized, @NotNull Duration durationBetweenStartupAndConnectorCreated) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndComponentResized, (String)"durationBetweenStartupAndComponentResized");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndConnectorCreated, (String)"durationBetweenStartupAndConnectorCreated");
        log.info("Terminal started with " + connector.getClass().getName() + " (" + process.getClass().getName() + "), time to UI laid out: " + durationBetweenStartupAndComponentResized.toMillis() + " ms, time to process created: " + durationBetweenStartupAndConnectorCreated.toMillis() + " ms");
    }

    @NotNull
    public static final PtyProcess startProcess(@NotNull List<String> command2, @NotNull Map<String, String> envs, @NotNull Path initialWorkingDirectory, @NotNull TermSize initialTermSize) throws ExecuteProcessException {
        Intrinsics.checkNotNullParameter(command2, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)initialWorkingDirectory, (String)"initialWorkingDirectory");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        return (PtyProcess)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PtyProcess>, Object>(initialWorkingDirectory, command2, envs, initialTermSize, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ Path $initialWorkingDirectory;
            final /* synthetic */ List<String> $command;
            final /* synthetic */ Map<String, String> $envs;
            final /* synthetic */ TermSize $initialTermSize;
            {
                this.$initialWorkingDirectory = $initialWorkingDirectory;
                this.$command = $command;
                this.$envs = $envs;
                this.$initialTermSize = $initialTermSize;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = TerminalStartupKt.access$getEelApi(this.$initialWorkingDirectory, this.$command, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Pair)v0;
                        eelApi = (EelApi)var2_3.component1();
                        workingDirectory = (Path)var2_3.component2();
                        this.L$0 = eelApi;
                        this.L$1 = workingDirectory;
                        this.label = 2;
                        v1 = TerminalStartupKt.access$convertCommandToRemote(eelApi, this.$command, (Continuation)this);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        workingDirectory = (Path)this.L$1;
                        eelApi = (EelApi)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        remoteCommand = (List)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)remoteCommand);
                        this.label = 3;
                        v2 = TerminalStartupKt.access$doStartProcess(eelApi, remoteCommand, this.$envs, workingDirectory, this.$initialTermSize, (Continuation)this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl43
                    }
                    case 3: {
                        remoteCommand = (List)this.L$2;
                        workingDirectory = (Path)this.L$1;
                        eelApi = (EelApi)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PtyProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private static final Object convertCommandToRemote(EelApi eelApi, List<String> command, Continuation<? super List<String>> $completion) {
        if (!($completion instanceof convertCommandToRemote.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalStartupKt.access$convertCommandToRemote(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)eelApi.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE) || !TerminalStartupKt.isWslCommand(command)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.label = 1;
                v0 = eelApi.getExec().fetchLoginShellEnvVariables((Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                command = (List)$continuation.L$1;
                eelApi = (EelApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((v1 = (String)((Map)v0).get("SHELL")) == null) {
                    v1 = "/bin/sh";
                }
                shell = v1;
                var4_7 = new String[]{shell, "--login", "-i"};
                return CollectionsKt.listOf((Object[])var4_7);
            }
        }
        return command;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean isWslCommand(List<String> command2) {
        if (SystemInfo.isWindows) {
            String string = (String)CollectionsKt.getOrNull(command2, (int)0);
            if (string == null) {
                return false;
            }
            String exePath = string;
            String string2 = PathUtil.getFileName((String)exePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
            String exeFileName = string2;
            return StringsKt.equals((String)exeFileName, (String)"wsl.exe", (boolean)true) || StringsKt.equals((String)exeFileName, (String)"wsl", (boolean)true);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getEelApi(Path workingDirectory, List<String> command, Continuation<? super Pair<? extends EelApi, ? extends Path>> $completion) {
        if (!($completion instanceof getEelApi.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalStartupKt.access$getEelApi(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                wslDistribNameFromCommandline = TerminalStartupKt.getWslDistributionNameFromCommand(command);
                if (wslDistribNameFromCommandline == null) break;
                v0 = WslPath.Companion.parseWindowsUncPath(workingDirectory.toString());
                v1 = wslDistribNameFromWorkingDirectory = v0 != null ? v0.getDistributionId() : null;
                if (Intrinsics.areEqual((Object)wslDistribNameFromCommandline, (Object)wslDistribNameFromWorkingDirectory)) break;
                v2 = new WSLDistribution(wslDistribNameFromCommandline).getUNCRootPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getUNCRootPath(...)");
                wslRootPath = v2;
                eelDescriptor = EelProviderUtil.getEelDescriptor((Path)wslRootPath);
                if (Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)wslDistribNameFromCommandline);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)wslDistribNameFromWorkingDirectory);
                $continuation.L$4 = wslRootPath;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                $continuation.label = 1;
                v3 = eelDescriptor.toEelApi((Continuation)$continuation);
                if (v3 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl42
            }
            case 1: {
                eelDescriptor = (EelDescriptor)$continuation.L$5;
                wslRootPath = (Path)$continuation.L$4;
                wslDistribNameFromWorkingDirectory = (String)$continuation.L$3;
                wslDistribNameFromCommandline = (String)$continuation.L$2;
                command = (List)$continuation.L$1;
                workingDirectory = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl42:
                // 2 sources

                eelApi = (EelApi)v3;
                $i$a$-runCatching-TerminalStartupKt$getEelApi$userHome$1 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)wslDistribNameFromCommandline);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)wslDistribNameFromWorkingDirectory);
                $continuation.L$4 = wslRootPath;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                $continuation.L$6 = eelApi;
                $continuation.I$0 = $i$a$-runCatching-TerminalStartupKt$getEelApi$userHome$1;
                $continuation.label = 2;
                v4 = eelApi.getExec().fetchLoginShellEnvVariables((Continuation)$continuation);
                ** if (v4 != var13_5) goto lbl59
lbl58:
                // 1 sources

                return var13_5;
lbl59:
                // 1 sources

                ** GOTO lbl73
            }
            case 2: {
                $i$a$-runCatching-TerminalStartupKt$getEelApi$userHome$1 = $continuation.I$0;
                eelApi = (EelApi)$continuation.L$6;
                eelDescriptor = (EelDescriptor)$continuation.L$5;
                wslRootPath = (Path)$continuation.L$4;
                wslDistribNameFromWorkingDirectory = (String)$continuation.L$3;
                wslDistribNameFromCommandline = (String)$continuation.L$2;
                command = (List)$continuation.L$1;
                workingDirectory = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl73:
                    // 2 sources

                    var9_16 = Result.constructor-impl((Object)((String)((Map)v4).get("HOME")));
                }
                catch (Throwable var10_17) {
                    var9_16 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var10_17));
                }
                if ((v5 = (userHome = (String)(Result.isFailure-impl((Object)var9_16) != false ? null : var9_16))) == null) {
                    v5 = ".";
                }
                return TuplesKt.to((Object)eelApi, (Object)wslRootPath.resolve(v5));
            }
        }
        $continuation.L$0 = workingDirectory;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)wslDistribNameFromCommandline);
        $continuation.label = 3;
        v6 = EelProviderUtil.getEelDescriptor((Path)workingDirectory).toEelApi((Continuation)$continuation);
        if (v6 == var13_5) {
            return var13_5;
        }
        ** GOTO lbl95
        {
            case 3: {
                wslDistribNameFromCommandline = (String)$continuation.L$2;
                command = (List)$continuation.L$1;
                workingDirectory = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl95:
                // 2 sources

                return TuplesKt.to((Object)v6, (Object)workingDirectory);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String getWslDistributionNameFromCommand(List<String> command2) {
        String distributionOptionName;
        if (TerminalStartupKt.isWslCommand(command2) && (Intrinsics.areEqual((Object)(distributionOptionName = (String)CollectionsKt.getOrNull(command2, (int)1)), (Object)"-d") || Intrinsics.areEqual((Object)distributionOptionName, (Object)"--distribution"))) {
            return (String)CollectionsKt.getOrNull(command2, (int)2);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object doStartProcess(EelApi eelApi, List<String> command, Map<String, String> envs, Path workingDirectory, TermSize initialTermSize, Continuation<? super PtyProcess> $completion) throws ExecuteProcessException {
        if (!($completion instanceof doStartProcess.1)) ** GOTO lbl-1000
        var8_6 = $completion;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalStartupKt.access$doStartProcess(null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                execOptions = EelExecApiHelpersKt.spawnProcess((EelExecApi)eelApi.getExec(), (String)((String)CollectionsKt.first(command))).args(CollectionsKt.takeLast(command, (int)(command.size() - 1))).env(envs).workingDirectory(EelNioBridgeServiceKt.asEelPath((Path)workingDirectory)).interactionOptions((EelExecApi.InteractionOptions)new EelExecApi.Pty(initialTermSize.getColumns(), initialTermSize.getRows(), true));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)envs);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)initialTermSize);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)execOptions);
                $continuation.label = 1;
                v0 = execOptions.eelIt((Continuation)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl33
            }
            case 1: {
                execOptions = (EelExecApiHelpers.SpawnProcess)$continuation.L$5;
                initialTermSize = (TermSize)$continuation.L$4;
                workingDirectory = (Path)$continuation.L$3;
                envs = (Map)$continuation.L$2;
                command = (List)$continuation.L$1;
                eelApi = (EelApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                v1 = ((EelProcess)v0).convertToJavaProcess();
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.pty4j.PtyProcess");
                return (PtyProcess)v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final boolean shouldUseEelApi() {
        return Registry.Companion.is("terminal.use.EelApi", true);
    }

    public static final /* synthetic */ Object access$getEelApi(Path workingDirectory, List command2, Continuation $completion) {
        return TerminalStartupKt.getEelApi(workingDirectory, command2, (Continuation<? super Pair<? extends EelApi, ? extends Path>>)$completion);
    }

    public static final /* synthetic */ Object access$convertCommandToRemote(EelApi eelApi, List command2, Continuation $completion) {
        return TerminalStartupKt.convertCommandToRemote(eelApi, command2, (Continuation<? super List<String>>)$completion);
    }

    public static final /* synthetic */ Object access$doStartProcess(EelApi eelApi, List command2, Map envs, Path workingDirectory, TermSize initialTermSize, Continuation $completion) {
        return TerminalStartupKt.doStartProcess(eelApi, command2, envs, workingDirectory, initialTermSize, (Continuation<? super PtyProcess>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractTerminalRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

