/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.util.ArrayList;
import java.util.List;
import sun.java2d.jules.JulesTile;

public class IdleTileCache {
    static final int IDLE_TILE_SYNC_GRANULARITY = 16;
    static final ArrayList<JulesTile> idleBuffers = new ArrayList();
    ArrayList<JulesTile> idleTileWorkerCacheList = new ArrayList();
    ArrayList<JulesTile> idleTileConsumerCacheList = new ArrayList(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JulesTile getIdleTileWorker(int maxCache) {
        if (this.idleTileWorkerCacheList.size() == 0) {
            this.idleTileWorkerCacheList.ensureCapacity(maxCache);
            ArrayList<JulesTile> arrayList = idleBuffers;
            synchronized (arrayList) {
                for (int i = 0; i < maxCache && idleBuffers.size() > 0; ++i) {
                    this.idleTileWorkerCacheList.add(idleBuffers.remove(idleBuffers.size() - 1));
                }
            }
        }
        if (this.idleTileWorkerCacheList.size() > 0) {
            return this.idleTileWorkerCacheList.remove(this.idleTileWorkerCacheList.size() - 1);
        }
        return new JulesTile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTile(JulesTile tile) {
        if (tile != null && tile.hasBuffer()) {
            this.idleTileConsumerCacheList.add(tile);
            if (this.idleTileConsumerCacheList.size() > 16) {
                ArrayList<JulesTile> arrayList = idleBuffers;
                synchronized (arrayList) {
                    idleBuffers.addAll(this.idleTileConsumerCacheList);
                }
                this.idleTileConsumerCacheList.clear();
            }
        }
    }

    public void disposeRasterizerResources() {
        this.releaseTiles(this.idleTileWorkerCacheList);
    }

    public void disposeConsumerResources() {
        this.releaseTiles(this.idleTileConsumerCacheList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTiles(List<JulesTile> tileList) {
        if (tileList.size() > 0) {
            ArrayList<JulesTile> arrayList = idleBuffers;
            synchronized (arrayList) {
                idleBuffers.addAll(tileList);
            }
            tileList.clear();
        }
    }
}

