/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PathStatement;
import software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement;
import software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessScopePath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessScopePath> {
    private static final SdkField<PathStatement> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(AccessScopePath.getter(AccessScopePath::source)).setter(AccessScopePath.setter(Builder::source)).constructor(PathStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("source").build()}).build();
    private static final SdkField<PathStatement> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(AccessScopePath.getter(AccessScopePath::destination)).setter(AccessScopePath.setter(Builder::destination)).constructor(PathStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("destination").build()}).build();
    private static final SdkField<List<ThroughResourcesStatement>> THROUGH_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThroughResources").getter(AccessScopePath.getter(AccessScopePath::throughResources)).setter(AccessScopePath.setter(Builder::throughResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughResourceSet").unmarshallLocationName("throughResourceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThroughResourcesStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, THROUGH_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessScopePath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PathStatement source;
    private final PathStatement destination;
    private final List<ThroughResourcesStatement> throughResources;

    private AccessScopePath(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.throughResources = builder.throughResources;
    }

    public final PathStatement source() {
        return this.source;
    }

    public final PathStatement destination() {
        return this.destination;
    }

    public final boolean hasThroughResources() {
        return this.throughResources != null && !(this.throughResources instanceof SdkAutoConstructList);
    }

    public final List<ThroughResourcesStatement> throughResources() {
        return this.throughResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThroughResources() ? this.throughResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopePath)) {
            return false;
        }
        AccessScopePath other = (AccessScopePath)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && this.hasThroughResources() == other.hasThroughResources() && Objects.equals(this.throughResources(), other.throughResources());
    }

    public final String toString() {
        return ToString.builder((String)"AccessScopePath").add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("ThroughResources", this.hasThroughResources() ? this.throughResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ThroughResources": {
                return Optional.ofNullable(clazz.cast(this.throughResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("ThroughResourceSet", THROUGH_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessScopePath, T> g) {
        return obj -> g.apply((AccessScopePath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PathStatement source;
        private PathStatement destination;
        private List<ThroughResourcesStatement> throughResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScopePath model) {
            this.source(model.source);
            this.destination(model.destination);
            this.throughResources(model.throughResources);
        }

        public final PathStatement.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(PathStatement.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(PathStatement source) {
            this.source = source;
            return this;
        }

        public final PathStatement.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(PathStatement.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(PathStatement destination) {
            this.destination = destination;
            return this;
        }

        public final List<ThroughResourcesStatement.Builder> getThroughResources() {
            List<ThroughResourcesStatement.Builder> result = ThroughResourcesStatementListCopier.copyToBuilder(this.throughResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThroughResources(Collection<ThroughResourcesStatement.BuilderImpl> throughResources) {
            this.throughResources = ThroughResourcesStatementListCopier.copyFromBuilder(throughResources);
        }

        @Override
        public final Builder throughResources(Collection<ThroughResourcesStatement> throughResources) {
            this.throughResources = ThroughResourcesStatementListCopier.copy(throughResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(ThroughResourcesStatement ... throughResources) {
            this.throughResources(Arrays.asList(throughResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(Consumer<ThroughResourcesStatement.Builder> ... throughResources) {
            this.throughResources(Stream.of(throughResources).map(c -> (ThroughResourcesStatement)((ThroughResourcesStatement.Builder)ThroughResourcesStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccessScopePath build() {
            return new AccessScopePath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessScopePath> {
        public Builder source(PathStatement var1);

        default public Builder source(Consumer<PathStatement.Builder> source) {
            return this.source((PathStatement)((PathStatement.Builder)PathStatement.builder().applyMutation(source)).build());
        }

        public Builder destination(PathStatement var1);

        default public Builder destination(Consumer<PathStatement.Builder> destination) {
            return this.destination((PathStatement)((PathStatement.Builder)PathStatement.builder().applyMutation(destination)).build());
        }

        public Builder throughResources(Collection<ThroughResourcesStatement> var1);

        public Builder throughResources(ThroughResourcesStatement ... var1);

        public Builder throughResources(Consumer<ThroughResourcesStatement.Builder> ... var1);
    }
}

