'''OpenGL extension OES.EGL_image

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.EGL_image to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a mechanism for creating texture and
	renderbuffer objects sharing storage with specified EGLImage objects
	(such objects are referred to as "EGLImage targets").
	
	The companion EGL_KHR_image_base and EGL_KHR_image extensions
	provide the definition and rationale for EGLImage objects.
	
	Other EGL extensions, such as EGL_KHR_gl_texture_2D_image,
	EGL_KHR_gl_texture_cubemap_image, EGL_KHR_gl_texture_3D_image,
	EGL_KHR_gl_renderbuffer_image, and EGL_KHR_vg_parent_image, define
	the related functionality of creating EGLImage objects from
	"EGLImage sources" such as OpenGL ES texture or renderbuffers or
	OpenVG VGImage objects.
	
	EGL extension specifications are located in the EGL Registry at
	
	    http://www.khronos.org/registry/egl/

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/EGL_image.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.EGL_image import *
from OpenGL.raw.GLES2.OES.EGL_image import _EXTENSION_NAME

def glInitEglImageOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION