﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/ExportResourceSpecification.h>
#include <aws/lexv2-models/model/ExportStatus.h>
#include <aws/lexv2-models/model/ImportExportFileFormat.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class CreateExportResult {
 public:
  AWS_LEXMODELSV2_API CreateExportResult() = default;
  AWS_LEXMODELSV2_API CreateExportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API CreateExportResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An identifier for a specific request to create an export.</p>
   */
  inline const Aws::String& GetExportId() const { return m_exportId; }
  template <typename ExportIdT = Aws::String>
  void SetExportId(ExportIdT&& value) {
    m_exportIdHasBeenSet = true;
    m_exportId = std::forward<ExportIdT>(value);
  }
  template <typename ExportIdT = Aws::String>
  CreateExportResult& WithExportId(ExportIdT&& value) {
    SetExportId(std::forward<ExportIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the type of resource that was exported, either a bot or a
   * bot locale.</p>
   */
  inline const ExportResourceSpecification& GetResourceSpecification() const { return m_resourceSpecification; }
  template <typename ResourceSpecificationT = ExportResourceSpecification>
  void SetResourceSpecification(ResourceSpecificationT&& value) {
    m_resourceSpecificationHasBeenSet = true;
    m_resourceSpecification = std::forward<ResourceSpecificationT>(value);
  }
  template <typename ResourceSpecificationT = ExportResourceSpecification>
  CreateExportResult& WithResourceSpecification(ResourceSpecificationT&& value) {
    SetResourceSpecification(std::forward<ResourceSpecificationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The file format used for the bot or bot locale definition files.</p>
   */
  inline ImportExportFileFormat GetFileFormat() const { return m_fileFormat; }
  inline void SetFileFormat(ImportExportFileFormat value) {
    m_fileFormatHasBeenSet = true;
    m_fileFormat = value;
  }
  inline CreateExportResult& WithFileFormat(ImportExportFileFormat value) {
    SetFileFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the export. When the status is <code>Completed</code>, you can
   * use the <a
   * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
   * operation to get the pre-signed S3 URL link to your exported bot or bot
   * locale.</p>
   */
  inline ExportStatus GetExportStatus() const { return m_exportStatus; }
  inline void SetExportStatus(ExportStatus value) {
    m_exportStatusHasBeenSet = true;
    m_exportStatus = value;
  }
  inline CreateExportResult& WithExportStatus(ExportStatus value) {
    SetExportStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the request to export a bot was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  CreateExportResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateExportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exportId;

  ExportResourceSpecification m_resourceSpecification;

  ImportExportFileFormat m_fileFormat{ImportExportFileFormat::NOT_SET};

  ExportStatus m_exportStatus{ExportStatus::NOT_SET};

  Aws::Utils::DateTime m_creationDateTime{};

  Aws::String m_requestId;
  bool m_exportIdHasBeenSet = false;
  bool m_resourceSpecificationHasBeenSet = false;
  bool m_fileFormatHasBeenSet = false;
  bool m_exportStatusHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
