#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-IPRf6a3v1vwGda6g7PiufF
key:                  dhall-1.42.2-IPRf6a3v1vwGda6g7PiufF
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  6ed4433fd5c57969f55ae013d838719a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-IPRf6a3v1vwGda6g7PiufF
depends:
    Diff-0.4.1-7aKWbaxEjXuGNL7kuqoq7g
    aeson-2.1.2.1-6jLf9XnWqJCFwZgyNgcXK5
    aeson-pretty-0.8.10-GV7QdDzqLCy55dCd8lp47a
    ansi-terminal-1.0.2-2SdInZ2XzOpHxNy7zA9Y2f
    atomic-write-0.2.1.1-8oIAZisZemY9iTAi2FrVZP base-4.17.2.1
    base16-bytestring-1.0.2.0-1KBZ5ZZPFeSCnwHUKcc29o
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-7gqgHDj4ifWAUMF7u0wWwn
    cborg-0.2.10.0-Es8nfvbkfzeHxf4szKEEqN
    cborg-json-0.2.6.0-BefFemb9POq58PVd7Kh3as containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-4VBSeQTpF3u5ZDJY8bGL4o
    data-fix-0.3.4-DZhirzyW6Q1ND1doZdJKs deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-E9iqKgyFrs6EyXlilfRgNm exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-7f3HQwRqSw36nixS6dVJ3n
    hashable-1.4.4.0-8IAMfvJ5RiNBptVjfaEAIZ haskeline-0.8.2
    http-client-0.7.18-5BYajw3HNj1oXnoQDXsjn
    http-client-tls-0.3.6.4-4PUk1Sm7hrWCzNb0l1rbJm
    http-types-0.12.4-5kSnAXEr074KLJnh9ObNlR
    indexed-traversable-0.1.4-9YXKO6oMx1B7bSWe0dnRh7
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-EOzDd62z05A746SrHFAgQv
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-Ezz3DgCiNVkB3lRSna1Fn6
    optparse-applicative-0.18.1.0-6SU84hJLh447fL9O7dNXXg
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-9tMx6aUfPwXClDhRyF1aMH
    pretty-simple-4.1.3.0-J1z3ITg6a5Y5aT65I5QtZQ
    prettyprinter-1.7.1-51OmHe2bsb6Aqd2q2orwqG
    prettyprinter-ansi-terminal-1.1.3-GgwSY2ez0MgLIVySkvW1mc
    profunctors-5.6.3-HkDOXx1Uj3cE0VHbxKtxGH
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-HO6fZYKmOY5KBpmsmPggyV
    serialise-0.2.6.1-BHWK1X1bc1ULGJTp1RUkFB template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-Icay4eIOquTATmiW1Xl6pk
    text-short-0.1.6-Ft8ifG1PMNdE1wx0FtvU3P
    th-lift-instances-0.1.20-1Y62qKGKBceAJuqhngc3Ai time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-HkSDHmVP773IOTMwC0oeWA
    unordered-containers-0.2.20-C8J7H3CMcSh2WWoYFsvixL
    vector-0.13.2.0-DHb3zbtAYMJG5fP738ULIp

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

