/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.utilities;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.freeplane.plugin.ai.tools.utilities.CancellationToolExecutor;
import org.freeplane.plugin.ai.tools.utilities.EventDispatchToolExecutor;
import org.freeplane.plugin.ai.tools.utilities.ToolExecutorRegistry;

public class ToolExecutorFactory {
    private final boolean wrapToolArgumentsExceptions;
    private final boolean propagateToolExecutionExceptions;
    private final Supplier<Boolean> cancellationSupplier;

    public ToolExecutorFactory(boolean wrapToolArgumentsExceptions, boolean propagateToolExecutionExceptions) {
        this(wrapToolArgumentsExceptions, propagateToolExecutionExceptions, null);
    }

    public ToolExecutorFactory(boolean wrapToolArgumentsExceptions, boolean propagateToolExecutionExceptions, Supplier<Boolean> cancellationSupplier) {
        this.wrapToolArgumentsExceptions = wrapToolArgumentsExceptions;
        this.propagateToolExecutionExceptions = propagateToolExecutionExceptions;
        this.cancellationSupplier = cancellationSupplier;
    }

    public ToolExecutorRegistry createRegistry(Object toolSet) {
        Objects.requireNonNull(toolSet, "toolSet");
        LinkedHashMap<String, EventDispatchToolExecutor> executorsByName = new LinkedHashMap<String, EventDispatchToolExecutor>();
        LinkedHashMap<ToolSpecification, EventDispatchToolExecutor> executorsBySpecification = new LinkedHashMap<ToolSpecification, EventDispatchToolExecutor>();
        ArrayList<ToolSpecification> specifications = new ArrayList<ToolSpecification>();
        for (Method method : toolSet.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Tool.class)) continue;
            ToolSpecification specification = ToolSpecifications.toolSpecificationFrom((Method)method);
            DefaultToolExecutor executor = DefaultToolExecutor.builder().object(toolSet).originalMethod(method).methodToInvoke(method).wrapToolArgumentsExceptions(Boolean.valueOf(this.wrapToolArgumentsExceptions)).propagateToolExecutionExceptions(Boolean.valueOf(this.propagateToolExecutionExceptions)).build();
            Object toolExecutor = new EventDispatchToolExecutor((ToolExecutor)executor);
            if (this.cancellationSupplier != null) {
                toolExecutor = new CancellationToolExecutor((ToolExecutor)toolExecutor, this.cancellationSupplier);
            }
            executorsByName.put(specification.name(), (EventDispatchToolExecutor)toolExecutor);
            executorsBySpecification.put(specification, (EventDispatchToolExecutor)toolExecutor);
            specifications.add(specification);
        }
        ToolSpecifications.validateSpecifications(specifications);
        return new ToolExecutorRegistry(Collections.unmodifiableMap(executorsByName), Collections.unmodifiableMap(executorsBySpecification));
    }
}

