/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.UITools;

public class ScaledStyleSheet
extends StyleSheet {
    private static final long serialVersionUID = 1L;
    private final float fontScaleFactor;

    public ScaledStyleSheet() {
        this(UITools.FONT_SCALE_FACTOR);
    }

    public ScaledStyleSheet(float fontScaleFactor) {
        this.fontScaleFactor = fontScaleFactor;
    }

    @Override
    public Font getFont(AttributeSet a) {
        Font font = super.getFont(a);
        float effectiveFontScaleFactor = this.getFontScaleFactor(a);
        return super.getFont(font.getFamily(), font.getStyle(), Math.round(font.getSize2D() * effectiveFontScaleFactor));
    }

    private float getFontScaleFactor(AttributeSet a) {
        if (a == null) {
            return this.fontScaleFactor;
        }
        Object attribute = a.getAttribute(CSS.Attribute.FONT_SIZE);
        if (attribute == null) {
            return this.fontScaleFactor;
        }
        String fontSize = attribute.toString();
        int fsLength = fontSize.length();
        if (fsLength <= 1 || Character.isDigit(fontSize.charAt(fsLength - 1)) || fontSize.endsWith("pt")) {
            return this.fontScaleFactor;
        }
        if (fontSize.endsWith("px")) {
            return 0.7692308f;
        }
        if (fontSize.endsWith("%") || fontSize.endsWith("em") || fontSize.endsWith("ex") || fontSize.endsWith("er")) {
            return this.getFontScaleFactor(a.getResolveParent());
        }
        return this.fontScaleFactor;
    }
}

