/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Tooltip;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Shape {
    protected static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG = false;
    private static final int DIRTY_SHAPE = 1;
    private static final int DIRTY_STATE = 2;
    private volatile Group parent = null;
    protected final AABBox box = new AABBox();
    private final Vec3f position = new Vec3f();
    private float zOffset = 0.0f;
    private final Quaternion rotation = new Quaternion();
    private Vec3f rotPivot = null;
    private final Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private final Matrix4f iMat = new Matrix4f();
    private final Matrix4f tmpMat = new Matrix4f();
    private volatile boolean iMatIdent = true;
    private volatile boolean iMatDirty = false;
    private final AtomicInteger dirty = new AtomicInteger(3);
    private final Object dirtySync = new Object();
    protected final Vec4f rgbaColor = new Vec4f(0.6f, 0.6f, 0.6f, 1.0f);
    protected final Vec4f pressedRGBAModulate = new Vec4f(0.7f, 0.7f, 0.7f, 0.8f);
    protected final Vec4f toggleOnRGBAModulate = new Vec4f(0.83f, 0.83f, 0.83f, 1.0f);
    protected final Vec4f toggleOffRGBAModulate = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
    protected final Vec4f activeRGBAModulate = new Vec4f(0.25f, 0.25f, 0.25f, 1.0f);
    protected boolean activeRGBAModulateOn = false;
    private final Vec4f rgba_tmp = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vec4f cWhite = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
    private int id = -1;
    private String name = "noname";
    private static final int IO_VISIBLE = 1;
    private static final int IO_INTERACTIVE = 2;
    private static final int IO_ACTIVABLE = 4;
    private static final int IO_TOGGLEABLE = 8;
    private static final int IO_DRAGGABLE = 16;
    private static final int IO_RESIZABLE = 32;
    private static final int IO_RESIZE_FIXED_RATIO = 64;
    private static final int IO_ACTIVE = 128;
    private static final int IO_DISCARDED = 0x2000000;
    private static final int IO_DOWN = 0x4000000;
    private static final int IO_TOGGLE = 0x8000000;
    private static final int IO_DRAG_FIRST = 0x10000000;
    private static final int IO_IN_MOVE = 0x20000000;
    private static final int IO_IN_RESIZE_BR = 0x40000000;
    private static final int IO_IN_RESIZE_BL = Integer.MIN_VALUE;
    private volatile int ioState = 55;
    private float borderThickness = 0.0f;
    private Padding padding = null;
    private final Vec4f borderColor = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    private ArrayList<MouseGestureListener> mouseListeners = new ArrayList();
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private DrawListener onDrawListener = null;
    private PointerListener onHoverListener = null;
    private MoveListener onMoveListener = null;
    private Listener onToggleListener = null;
    private ArrayList<Listener> activationListeners = new ArrayList();
    private PointerListener onClickedListener = null;
    private final Vec2f objDraggedFirst = new Vec2f();
    private final int[] winDraggedLast = new int[]{0, 0};
    private static final float resize_sxy_min = 0.005f;
    private static final float resize_section = 0.2f;
    private volatile Tooltip tooltip = null;
    public static Comparator<Shape> ZAscendingComparator = new Comparator<Shape>(){

        @Override
        public int compare(Shape shape, Shape shape2) {
            return Shape.compareAsc1(shape.getAdjustedZ(), shape2.getAdjustedZ());
        }
    };
    public static Comparator<Shape> ZDescendingComparator = new Comparator<Shape>(){

        @Override
        public int compare(Shape shape, Shape shape2) {
            return Shape.compareDesc1(shape2.getAdjustedZ(), shape.getAdjustedZ());
        }
    };

    private final boolean isIO(int n) {
        return n == (this.ioState & n);
    }

    private final Shape setIO(int n, boolean bl) {
        this.ioState = bl ? (this.ioState |= n) : (this.ioState &= ~n);
        return this;
    }

    protected Shape() {
    }

    protected void setParent(Group group) {
        this.parent = group;
    }

    public Group getParent() {
        return this.parent;
    }

    public final Shape setID(int n) {
        this.id = n;
        return this;
    }

    public final int getID() {
        return this.id;
    }

    public Shape setName(String string) {
        this.name = string;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public boolean isGroup() {
        return false;
    }

    public final boolean isVisible() {
        return this.isIO(1);
    }

    public final Shape setVisible(boolean bl) {
        return this.setIO(1, bl);
    }

    public final Shape setPaddding(Padding padding) {
        this.padding = padding;
        this.markShapeDirty();
        return this;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public boolean hasPadding() {
        return null != this.padding && !this.padding.zeroSize();
    }

    public final Shape setBorder(float f) {
        this.borderThickness = Math.max(0.0f, f);
        this.markShapeDirty();
        return this;
    }

    public final boolean hasBorder() {
        return !FloatUtil.isZero(this.borderThickness);
    }

    public final float getBorderThickness() {
        return this.borderThickness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runSynced(Runnable runnable) {
        Object object = this.dirtySync;
        synchronized (object) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        Object object = this.dirtySync;
        synchronized (object) {
            this.stopTooltip();
            this.clearImpl0(gL2ES2, regionRenderer);
            this.resetState();
        }
    }

    private final void resetState() {
        this.position.set(0.0f, 0.0f, 0.0f);
        this.rotation.setIdentity();
        this.rotPivot = null;
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.iMat.loadIdentity();
        this.iMatIdent = true;
        this.iMatDirty = false;
        this.box.reset();
        this.mouseListeners.clear();
        this.keyListeners.clear();
        this.onDrawListener = null;
        this.onMoveListener = null;
        this.onToggleListener = null;
        this.activationListeners.clear();
        this.onClickedListener = null;
        this.onHoverListener = null;
        this.markShapeDirty();
    }

    public final void destroy(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.removeTooltip();
        this.destroyImpl0(gL2ES2, regionRenderer);
        this.resetState();
    }

    public final void onDraw(DrawListener drawListener) {
        this.onDrawListener = drawListener;
    }

    public final void onHover(PointerListener pointerListener) {
        this.onHoverListener = pointerListener;
    }

    public final void onMove(MoveListener moveListener) {
        this.onMoveListener = moveListener;
    }

    public final void onToggle(Listener listener) {
        this.onToggleListener = listener;
    }

    public final void onClicked(PointerListener pointerListener) {
        this.onClickedListener = pointerListener;
    }

    public final Shape addActivationListener(Listener listener) {
        if (listener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.activationListeners.clone();
        arrayList.add(listener);
        this.activationListeners = arrayList;
        return this;
    }

    public final Shape removeActivationListener(Listener listener) {
        if (listener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.activationListeners.clone();
        arrayList.remove(listener);
        this.activationListeners = arrayList;
        return this;
    }

    protected final void dispatchActivationEvent(Shape shape) {
        int n = this.activationListeners.size();
        for (int i = 0; i < n; ++i) {
            this.activationListeners.get(i).run(shape);
        }
    }

    public final Shape moveTo(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
        this.iMatDirty = true;
        return this;
    }

    public final Shape moveTo(Vec3f vec3f) {
        this.position.set(vec3f);
        this.iMatDirty = true;
        return this;
    }

    public final Shape move(float f, float f2, float f3) {
        this.position.add(f, f2, f3);
        this.iMatDirty = true;
        return this;
    }

    public final Shape move(Vec3f vec3f) {
        this.position.add(vec3f);
        this.iMatDirty = true;
        return this;
    }

    private final Shape moveNotify(float f, float f2, float f3, MouseEvent mouseEvent) {
        this.forwardMove(this.position.copy(), this.position.add(f, f2, f3), mouseEvent);
        return this;
    }

    private final void forwardMove(Vec3f vec3f, Vec3f vec3f2, MouseEvent mouseEvent) {
        if (!vec3f.isEqual(vec3f2)) {
            this.iMatDirty = true;
            if (null != this.onMoveListener) {
                this.onMoveListener.run(this, vec3f, vec3f2, mouseEvent);
            }
        }
    }

    public final Vec3f getPosition() {
        this.iMatDirty = true;
        return this.position;
    }

    public final Quaternion getRotation() {
        this.iMatDirty = true;
        return this.rotation;
    }

    public final Shape setRotation(Quaternion quaternion) {
        this.rotation.set(quaternion);
        this.iMatDirty = true;
        return this;
    }

    public final Vec3f getRotationPivot() {
        return this.rotPivot;
    }

    public final Shape setRotationPivot(float f, float f2, float f3) {
        this.rotPivot = new Vec3f(f, f2, f3);
        this.iMatDirty = true;
        return this;
    }

    public final Shape setRotationPivot(Vec3f vec3f) {
        this.rotPivot = new Vec3f(vec3f);
        this.iMatDirty = true;
        return this;
    }

    public final Shape setScale(Vec3f vec3f) {
        this.scale.set(vec3f);
        this.iMatDirty = true;
        return this;
    }

    public final Shape setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
        this.iMatDirty = true;
        return this;
    }

    public final Shape scale(Vec3f vec3f) {
        this.scale.mul(vec3f);
        this.iMatDirty = true;
        return this;
    }

    public final Shape scale(float f, float f2, float f3) {
        this.scale.mul(f, f2, f3);
        this.iMatDirty = true;
        return this;
    }

    public final Vec3f getScale() {
        return this.scale;
    }

    public final void markShapeDirty() {
        this.dirty.updateAndGet(n -> n | 1);
    }

    public final void markStateDirty() {
        this.dirty.updateAndGet(n -> n | 2);
    }

    protected boolean isShapeDirty() {
        return 0 != (this.dirty.get() & 1);
    }

    protected final boolean isStateDirty() {
        return 0 != (this.dirty.get() & 2);
    }

    protected final String getDirtyString() {
        if (this.isShapeDirty() && this.isShapeDirty()) {
            return "dirty[shape, state]";
        }
        if (this.isShapeDirty()) {
            return "dirty[shape]";
        }
        if (this.isStateDirty()) {
            return "dirty[state]";
        }
        return "clean";
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final float getScaledWidth() {
        return this.box.getWidth() * this.getScale().x();
    }

    public final float getScaledHeight() {
        return this.box.getHeight() * this.getScale().y();
    }

    public final float getScaledDepth() {
        return this.box.getDepth() * this.getScale().z();
    }

    public final AABBox getBounds(GLProfile gLProfile) {
        this.validate(gLProfile);
        return this.box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawToSelect(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        Object object = this.dirtySync;
        synchronized (object) {
            this.validate(gL2ES2);
            this.drawToSelectImpl0(gL2ES2, regionRenderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        Vec4f vec4f;
        boolean bl = this.isPressed();
        boolean bl2 = this.isToggleOn();
        if (this.hasColorChannel()) {
            vec4f = bl ? this.pressedRGBAModulate : (this.isToggleable() ? (bl2 ? this.toggleOnRGBAModulate : this.toggleOffRGBAModulate) : (this.activeRGBAModulateOn && this.isActive() ? this.activeRGBAModulate : this.cWhite));
        } else {
            vec4f = this.rgba_tmp;
            if (bl) {
                vec4f.mul(this.rgbaColor, this.pressedRGBAModulate);
            } else if (this.isToggleable()) {
                if (bl2) {
                    vec4f.mul(this.rgbaColor, this.toggleOnRGBAModulate);
                } else {
                    vec4f.mul(this.rgbaColor, this.toggleOffRGBAModulate);
                }
            } else if (this.activeRGBAModulateOn && this.isActive()) {
                vec4f.mul(this.rgbaColor, this.activeRGBAModulate);
            } else {
                vec4f.set(this.rgbaColor);
            }
        }
        Object object = this.dirtySync;
        synchronized (object) {
            this.validate(gL2ES2);
            this.drawImpl0(gL2ES2, regionRenderer, vec4f);
        }
        if (null != this.onDrawListener && this.onDrawListener.run(this, gL2ES2, regionRenderer)) {
            this.onDrawListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape validate(GL2ES2 gL2ES2) {
        Object object = this.dirtySync;
        synchronized (object) {
            if (this.isShapeDirty()) {
                this.box.reset();
            }
            this.validateImpl(gL2ES2, gL2ES2.getGLProfile());
            this.dirty.set(0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape validate(GLProfile gLProfile) {
        Object object = this.dirtySync;
        synchronized (object) {
            if (this.isShapeDirty()) {
                this.box.reset();
            }
            this.validateImpl(null, gLProfile);
            this.dirty.set(0);
        }
        return this;
    }

    public final Shape validate(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (null != gL2ES2) {
            return this.validate(gL2ES2);
        }
        return this.validate(gLProfile);
    }

    public final void applyMatToMv(PMVMatrix4f pMVMatrix4f) {
        if (this.iMatDirty) {
            this.updateMat();
        }
        if (!this.iMatIdent) {
            pMVMatrix4f.mulMv(this.iMat);
        }
    }

    public final Matrix4f getMat() {
        if (this.iMatDirty) {
            this.updateMat();
        }
        return this.iMat;
    }

    public final Matrix4f getMat(Matrix4f matrix4f) {
        if (this.iMatDirty) {
            this.updateMat();
        }
        matrix4f.load(this.iMat);
        return matrix4f;
    }

    public final boolean isMatIdentity() {
        return this.iMatIdent;
    }

    public final void updateMat() {
        boolean bl;
        boolean bl2 = !this.position.isZero();
        boolean bl3 = !this.scale.isEqual(Vec3f.ONE);
        boolean bl4 = !this.rotation.isIdentity();
        boolean bl5 = null != this.rotPivot;
        Vec3f vec3f = this.box.getCenter();
        boolean bl6 = bl = bl3 && bl4 && (!bl5 || this.rotPivot.isEqual(vec3f));
        if (bl) {
            this.iMatIdent = false;
            this.iMat.setToTranslation(this.position);
            this.iMat.translate(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z(), this.tmpMat);
            this.iMat.rotate(this.rotation, this.tmpMat);
            this.iMat.scale(this.scale.x(), this.scale.y(), this.scale.z(), this.tmpMat);
            this.iMat.translate(-vec3f.x(), -vec3f.y(), -vec3f.z(), this.tmpMat);
        } else if (bl4 || bl3) {
            this.iMatIdent = false;
            this.iMat.setToTranslation(this.position);
            if (bl4) {
                if (bl5) {
                    this.iMat.translate(this.rotPivot.x() * this.scale.x(), this.rotPivot.y() * this.scale.y(), this.rotPivot.z() * this.scale.z(), this.tmpMat);
                    this.iMat.rotate(this.rotation, this.tmpMat);
                    this.iMat.translate(-this.rotPivot.x() * this.scale.x(), -this.rotPivot.y() * this.scale.y(), -this.rotPivot.z() * this.scale.z(), this.tmpMat);
                } else {
                    this.iMat.translate(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z(), this.tmpMat);
                    this.iMat.rotate(this.rotation, this.tmpMat);
                    this.iMat.translate(-vec3f.x() * this.scale.x(), -vec3f.y() * this.scale.y(), -vec3f.z() * this.scale.z(), this.tmpMat);
                }
            }
            if (bl3) {
                this.iMat.translate(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z(), this.tmpMat);
                this.iMat.scale(this.scale.x(), this.scale.y(), this.scale.z(), this.tmpMat);
                this.iMat.translate(-vec3f.x(), -vec3f.y(), -vec3f.z(), this.tmpMat);
            }
        } else if (bl2) {
            this.iMatIdent = false;
            this.iMat.setToTranslation(this.position);
        } else {
            this.iMatIdent = true;
            this.iMat.loadIdentity();
        }
        this.iMatDirty = false;
    }

    public final PMVMatrix4f setPMVMatrix(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, PMVMatrix4f pMVMatrix4f) {
        pMVMatrixSetup.set(pMVMatrix4f, recti);
        this.applyMatToMv(pMVMatrix4f);
        return pMVMatrix4f;
    }

    public final PMVMatrix4f setPMVMatrix(Scene scene, PMVMatrix4f pMVMatrix4f) {
        return this.setPMVMatrix(scene.getPMVMatrixSetup(), scene.getViewport(), pMVMatrix4f);
    }

    public final Recti getSurfacePort(PMVMatrix4f pMVMatrix4f, Recti recti, Recti recti2) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = this.box.getHigh();
        Vec3f vec3f4 = this.box.getLow();
        Matrix4f matrix4f = pMVMatrix4f.getPMv();
        if (Matrix4f.mapObjToWin(vec3f3, matrix4f, recti, vec3f) && Matrix4f.mapObjToWin(vec3f4, matrix4f, recti, vec3f2)) {
            recti2.setX((int)Math.abs(vec3f2.x()));
            recti2.setY((int)Math.abs(vec3f2.y()));
            recti2.setWidth((int)Math.abs(vec3f.x() - vec3f2.x()));
            recti2.setHeight((int)Math.abs(vec3f.y() - vec3f2.y()));
            return recti2;
        }
        return null;
    }

    public final int[] getSurfaceSize(PMVMatrix4f pMVMatrix4f, Recti recti, int[] nArray) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = this.box.getHigh();
        Vec3f vec3f4 = this.box.getLow();
        Matrix4f matrix4f = pMVMatrix4f.getPMv();
        if (Matrix4f.mapObjToWin(vec3f3, matrix4f, recti, vec3f) && Matrix4f.mapObjToWin(vec3f4, matrix4f, recti, vec3f2)) {
            nArray[0] = (int)Math.abs(vec3f.x() - vec3f2.x());
            nArray[1] = (int)Math.abs(vec3f.y() - vec3f2.y());
            return nArray;
        }
        return null;
    }

    public final int[] getSurfaceSize(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, PMVMatrix4f pMVMatrix4f, int[] nArray) {
        return this.getSurfaceSize(this.setPMVMatrix(pMVMatrixSetup, recti, pMVMatrix4f), recti, nArray);
    }

    public final int[] getSurfaceSize(Scene scene, PMVMatrix4f pMVMatrix4f, int[] nArray) {
        return this.getSurfaceSize(scene.getPMVMatrixSetup(), scene.getViewport(), pMVMatrix4f, nArray);
    }

    public final float[] getPixelPerShapeUnit(int[] nArray, float[] fArray) {
        fArray[0] = (float)nArray[0] / this.getScaledWidth();
        fArray[0] = (float)nArray[1] / this.getScaledHeight();
        return fArray;
    }

    public final float[] getPixelPerShapeUnit(PMVMatrix4f pMVMatrix4f, Recti recti, float[] fArray) {
        int[] nArray = new int[2];
        if (null != this.getSurfaceSize(pMVMatrix4f, recti, nArray)) {
            return this.getPixelPerShapeUnit(nArray, fArray);
        }
        return null;
    }

    public final float[] getPixelPerShapeUnit(Scene scene, PMVMatrix4f pMVMatrix4f, float[] fArray) {
        int[] nArray = new int[2];
        if (null != this.getSurfaceSize(scene, pMVMatrix4f, nArray)) {
            return this.getPixelPerShapeUnit(nArray, fArray);
        }
        return null;
    }

    public final int[] shapeToWinCoord(PMVMatrix4f pMVMatrix4f, Recti recti, Vec3f vec3f, int[] nArray) {
        Vec3f vec3f2 = new Vec3f();
        if (pMVMatrix4f.mapObjToWin(vec3f, recti, vec3f2)) {
            nArray[0] = (int)vec3f2.x();
            nArray[1] = (int)vec3f2.y();
            return nArray;
        }
        return null;
    }

    public final int[] shapeToWinCoord(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, Vec3f vec3f, PMVMatrix4f pMVMatrix4f, int[] nArray) {
        return this.shapeToWinCoord(this.setPMVMatrix(pMVMatrixSetup, recti, pMVMatrix4f), recti, vec3f, nArray);
    }

    public final int[] shapeToWinCoord(Scene scene, Vec3f vec3f, PMVMatrix4f pMVMatrix4f, int[] nArray) {
        return this.shapeToWinCoord(scene.getPMVMatrixSetup(), scene.getViewport(), vec3f, pMVMatrix4f, nArray);
    }

    public final Vec3f winToShapeCoord(PMVMatrix4f pMVMatrix4f, Recti recti, int n, int n2, Vec3f vec3f) {
        float f;
        Vec3f vec3f2 = this.box.getCenter();
        if (Matrix4f.mapObjToWin(vec3f2, pMVMatrix4f.getPMv(), recti, vec3f) && Matrix4f.mapWinToObj(n, n2, f = vec3f.z(), pMVMatrix4f.getPMvi(), recti, vec3f)) {
            return vec3f;
        }
        return null;
    }

    public final Vec3f winToShapeCoord(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, int n, int n2, PMVMatrix4f pMVMatrix4f, Vec3f vec3f) {
        return this.winToShapeCoord(this.setPMVMatrix(pMVMatrixSetup, recti, pMVMatrix4f), recti, n, n2, vec3f);
    }

    public final Vec3f winToShapeCoord(Scene scene, int n, int n2, PMVMatrix4f pMVMatrix4f, Vec3f vec3f) {
        return this.winToShapeCoord(scene.getPMVMatrixSetup(), scene.getViewport(), n, n2, pMVMatrix4f, vec3f);
    }

    public final Vec4f getColor() {
        return this.rgbaColor;
    }

    public final Vec4f getPressedColorMod() {
        return this.pressedRGBAModulate;
    }

    public final Vec4f getToggleOnColorMod() {
        return this.toggleOnRGBAModulate;
    }

    public final Vec4f getToggleOffColorMod() {
        return this.toggleOffRGBAModulate;
    }

    public final Vec4f getActiveColorMod() {
        return this.activeRGBAModulate;
    }

    public Shape setColor(float f, float f2, float f3, float f4) {
        this.rgbaColor.set(f, f2, f3, f4);
        this.markShapeDirty();
        return this;
    }

    public Shape setColor(Vec4f vec4f) {
        this.rgbaColor.set(vec4f);
        this.markShapeDirty();
        return this;
    }

    public Shape setPressedColorMod(float f, float f2, float f3, float f4) {
        this.pressedRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setToggleOnColorMod(float f, float f2, float f3, float f4) {
        this.toggleOnRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setToggleOffColorMod(float f, float f2, float f3, float f4) {
        this.toggleOffRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setActiveColorMod(Vec4f vec4f) {
        if (null == vec4f) {
            this.activeRGBAModulateOn = false;
        } else {
            this.activeRGBAModulateOn = true;
            this.activeRGBAModulate.set(vec4f);
        }
        return this;
    }

    public final Vec4f getBorderColor() {
        return this.borderColor;
    }

    public final Shape setBorderColor(float f, float f2, float f3, float f4) {
        this.borderColor.set(f, f2, f3, f4);
        this.markShapeDirty();
        return this;
    }

    public final Shape setBorderColor(Vec4f vec4f) {
        this.borderColor.set(vec4f);
        this.markShapeDirty();
        return this;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSubString() + "]";
    }

    public String getSubString() {
        String string;
        Object object;
        String string2 = this.iMatDirty ? "mat-dirty, " : (this.iMatIdent ? "mat-ident, " : "");
        String string3 = null != this.rotPivot ? "pivot[" + this.rotPivot + "], " : "";
        String string4 = !this.scale.isEqual(Vec3f.ONE) ? "scale[" + this.scale + "], " : "scale 1, ";
        if (!this.rotation.isIdentity()) {
            object = this.rotation.toEuler(new Vec3f());
            string = "rot[" + object + "], ";
        } else {
            string = "";
        }
        object = this.isDiscarded() ? ", DISCARDED" : "";
        String string5 = this.isActive() ? ", ACTIVE[adjZ " + this.getAdjustedZ() + "]" : "";
        String string6 = this.hasPadding() ? this.padding.toString() + ", " : "";
        String string7 = this.hasBorder() ? "border[l " + this.getBorderThickness() + ", c " + this.getBorderColor() + "], " : "";
        String string8 = -1 != this.id ? ", id " + this.id : "";
        String string9 = "noname" != this.name ? ", '" + this.name + "'" : "";
        return this.getDirtyString() + string8 + string9 + ", visible " + this.isIO(1) + (String)object + string5 + ", toggle " + this.isIO(0x8000000) + ", able[toggle " + this.isIO(8) + ", iactive " + this.isInteractive() + ", resize " + this.isResizable() + ", drag " + this.isDraggable() + "], pos[" + this.position + "], " + string3 + string4 + string + string2 + string6 + string7 + "box" + this.box;
    }

    public final Shape setPressed(boolean bl) {
        this.setIO(0x4000000, bl);
        this.markStateDirty();
        return this;
    }

    public final boolean isPressed() {
        return this.isIO(0x4000000);
    }

    public final Shape setToggleable(boolean bl) {
        return this.setIO(8, bl);
    }

    public boolean isToggleable() {
        return this.isIO(8);
    }

    public final Shape setToggle(boolean bl) {
        this.setIO(0x8000000, bl);
        this.toggleNotify(bl);
        if (null != this.onToggleListener) {
            this.onToggleListener.run(this);
        }
        this.markStateDirty();
        return this;
    }

    public final Shape toggle() {
        if (this.isToggleable()) {
            this.setIO(0x8000000, !this.isToggleOn());
            this.toggleNotify(this.isToggleOn());
            if (null != this.onToggleListener) {
                this.onToggleListener.run(this);
            }
            this.markStateDirty();
        }
        return this;
    }

    protected void toggleNotify(boolean bl) {
    }

    public final boolean isToggleOn() {
        return this.isIO(0x8000000);
    }

    protected final boolean setActive(boolean bl, float f) {
        if (this.isActivable()) {
            this.setZOffset(f);
            this.setIO(128, bl);
            if (!bl) {
                this.releaseInteraction();
                Tooltip tooltip = this.tooltip;
                if (null != tooltip) {
                    tooltip.stop(false);
                }
            }
            this.dispatchActivationEvent(this);
            return true;
        }
        return false;
    }

    public final boolean isActive() {
        return this.isIO(128);
    }

    void setActiveTopLevel(boolean bl, float f) {
        this.setZOffset(f);
        this.setIO(128, bl);
        this.dispatchActivationEvent(this);
    }

    public final float getAdjustedZ() {
        return this.position.z() * this.getScale().z() + this.zOffset;
    }

    final void setZOffset(float f) {
        this.zOffset = f;
    }

    public Tooltip setTooltip(Tooltip tooltip) {
        Tooltip tooltip2 = this.tooltip;
        this.tooltip = null;
        if (null != tooltip2) {
            tooltip2.stop(true);
        }
        tooltip.setTool(this);
        this.tooltip = tooltip;
        return tooltip;
    }

    public void removeTooltip() {
        Tooltip tooltip = this.tooltip;
        this.tooltip = null;
        if (null != tooltip) {
            tooltip.stop(true);
            tooltip.setTool(null);
        }
    }

    private void stopTooltip() {
        Tooltip tooltip = this.tooltip;
        if (null != tooltip) {
            tooltip.stop(true);
        }
    }

    Tooltip startTooltip(boolean bl) {
        Tooltip tooltip = this.tooltip;
        if (null != tooltip) {
            tooltip.start();
            return tooltip;
        }
        if (bl) {
            for (Group group = this.getParent(); null != group; group = group.getParent()) {
                tooltip = group.startTooltip(false);
                if (null == tooltip) continue;
                return tooltip;
            }
        }
        return null;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public final Shape setInteractive(boolean bl) {
        return this.setIO(2, bl);
    }

    public final boolean isInteractive() {
        return this.isIO(2);
    }

    public final Shape setActivable(boolean bl) {
        return this.setIO(4, bl);
    }

    public final boolean isActivable() {
        return this.isIO(4);
    }

    public final Shape setDiscarded(boolean bl) {
        return this.setIO(0x2000000, bl);
    }

    public final boolean isDiscarded() {
        return this.isIO(0x2000000);
    }

    public final Shape setDraggable(boolean bl) {
        return this.setIO(16, bl);
    }

    public final boolean isDraggable() {
        return this.isIO(16);
    }

    public final Shape setResizable(boolean bl) {
        return this.setIO(32, bl);
    }

    public final boolean isResizable() {
        return this.isIO(32);
    }

    public final boolean isFixedARatioResize() {
        return this.isIO(64);
    }

    public final Shape setFixedARatioResize(boolean bl) {
        return this.setIO(64, bl);
    }

    public final Shape setDragAndResizable(boolean bl) {
        this.setDraggable(bl);
        this.setResizable(bl);
        return this;
    }

    public final Shape addMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.add(mouseGestureListener);
        this.mouseListeners = arrayList;
        return this;
    }

    public final Shape removeMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseGestureListener);
        this.mouseListeners = arrayList;
        return this;
    }

    public void receiveMouseEvents(Shape shape) {
        shape.addMouseListener(new ForwardMouseListener(this));
    }

    public final Shape addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.add(keyListener);
        this.keyListeners = arrayList;
        return this;
    }

    public final Shape removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
        return this;
    }

    public void receiveKeyEvents(Shape shape) {
        shape.addKeyListener(new ForwardKeyListener(this));
    }

    private final void releaseInteraction() {
        this.setPressed(false);
        this.setIO(0x20000000, false);
        this.setIO(0x40000000, false);
        this.setIO(Integer.MIN_VALUE, false);
    }

    final boolean dispatchMouseEvent(MouseEvent mouseEvent, int n, int n2, Vec3f vec3f) {
        boolean bl = this.isResizable() || this.isDraggable();
        EventInfo eventInfo = new EventInfo(n, n2, this, vec3f);
        boolean bl2 = false;
        short s = mouseEvent.getEventType();
        if (1 == mouseEvent.getPointerCount()) {
            switch (s) {
                case 205: {
                    if (null != this.onHoverListener) {
                        this.onHoverListener.run(this, vec3f, mouseEvent);
                    }
                    bl2 = true;
                    break;
                }
                case 203: {
                    if (bl) {
                        this.setIO(0x10000000, true);
                        bl2 = true;
                    }
                    this.setPressed(true);
                    break;
                }
                case 204: {
                    this.releaseInteraction();
                    bl2 = true;
                    break;
                }
                case 200: {
                    if (this.isToggleable()) {
                        this.toggle();
                    }
                    if (null != this.onClickedListener) {
                        this.onClickedListener.run(this, vec3f, mouseEvent);
                    }
                    bl2 = true;
                }
            }
        }
        if (bl && 206 == s) {
            boolean bl3;
            Vec3f vec3f2 = this.rotation.toEuler(new Vec3f());
            float f = Math.abs(vec3f2.x());
            float f2 = Math.abs(vec3f2.y());
            boolean bl4 = 1.5707964f <= f2 && f2 <= 4.712389f;
            boolean bl5 = bl3 = 1.5707964f <= f && f <= 4.712389f;
            if (this.isIO(0x10000000)) {
                this.objDraggedFirst.set(vec3f);
                this.winDraggedLast[0] = n;
                this.winDraggedLast[1] = n2;
                this.setIO(0x10000000, false);
                f = bl4 ? this.box.getWidth() - vec3f.x() : vec3f.x();
                f2 = bl3 ? this.box.getHeight() - vec3f.y() : vec3f.y();
                float f3 = this.box.getMaxX() - this.box.getWidth() * 0.2f;
                float f4 = this.box.getMinY();
                float f5 = this.box.getMaxX();
                float f6 = this.box.getMinY() + this.box.getHeight() * 0.2f;
                if (f3 <= f && f <= f5 && f4 <= f2 && f2 <= f6) {
                    if (this.isResizable()) {
                        this.setIO(0x40000000, true);
                    }
                } else {
                    float f7 = this.box.getMinX();
                    float f8 = this.box.getMinY();
                    float f9 = this.box.getMinX() + this.box.getWidth() * 0.2f;
                    float f10 = this.box.getMinY() + this.box.getHeight() * 0.2f;
                    if (f7 <= f && f <= f9 && f8 <= f2 && f2 <= f10) {
                        if (this.isResizable()) {
                            this.setIO(Integer.MIN_VALUE, true);
                        }
                    } else {
                        this.setIO(0x20000000, this.isDraggable());
                    }
                }
                return true;
            }
            eventInfo.objDrag.set(vec3f.x() - this.objDraggedFirst.x(), vec3f.y() - this.objDraggedFirst.y());
            eventInfo.objDrag.mul(bl4 ? -1.0f : 1.0f, bl3 ? -1.0f : 1.0f);
            eventInfo.winDrag[0] = n - this.winDraggedLast[0];
            eventInfo.winDrag[1] = n2 - this.winDraggedLast[1];
            this.winDraggedLast[0] = n;
            this.winDraggedLast[1] = n2;
            if (1 == mouseEvent.getPointerCount()) {
                f = eventInfo.objDrag.x() * this.scale.x();
                f2 = eventInfo.objDrag.y() * this.scale.y();
                if (this.isIO(0x40000000) || this.isIO(Integer.MIN_VALUE)) {
                    float f11;
                    float f12;
                    float f13 = this.box.getWidth();
                    float f14 = this.box.getHeight();
                    float f15 = this.isIO(0x40000000) ? this.scale.x() + f / f13 : this.scale.x() - f / f13;
                    if (this.isFixedARatioResize()) {
                        f12 = f15;
                        f11 = f14 * (this.scale.y() - f12);
                    } else {
                        f11 = f2;
                        f12 = this.scale.y() - f11 / f14;
                    }
                    if (0.005f <= f15 && 0.005f <= f12) {
                        if (this.isIO(0x40000000)) {
                            this.moveNotify(0.0f, f11, 0.0f, mouseEvent);
                        } else {
                            this.moveNotify(f, f11, 0.0f, mouseEvent);
                        }
                        this.setScale(f15, f12, this.scale.z());
                    }
                    return true;
                }
                if (this.isIO(0x20000000)) {
                    this.moveNotify(f, f2, 0.0f, mouseEvent);
                    return true;
                }
            }
        }
        mouseEvent.setAttachment(eventInfo);
        return this.dispatchMouseEvent(mouseEvent) || bl2;
    }

    final boolean dispatchMouseEvent(MouseEvent mouseEvent) {
        short s = mouseEvent.getEventType();
        block10: for (int i = 0; !mouseEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            MouseGestureListener mouseGestureListener = this.mouseListeners.get(i);
            switch (s) {
                case 200: {
                    mouseGestureListener.mouseClicked(mouseEvent);
                    continue block10;
                }
                case 201: {
                    mouseGestureListener.mouseEntered(mouseEvent);
                    continue block10;
                }
                case 202: {
                    mouseGestureListener.mouseExited(mouseEvent);
                    continue block10;
                }
                case 203: {
                    mouseGestureListener.mousePressed(mouseEvent);
                    continue block10;
                }
                case 204: {
                    mouseGestureListener.mouseReleased(mouseEvent);
                    continue block10;
                }
                case 205: {
                    mouseGestureListener.mouseMoved(mouseEvent);
                    continue block10;
                }
                case 206: {
                    mouseGestureListener.mouseDragged(mouseEvent);
                    continue block10;
                }
                case 207: {
                    mouseGestureListener.mouseWheelMoved(mouseEvent);
                    continue block10;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
        return mouseEvent.isConsumed();
    }

    final void dispatchGestureEvent(GestureHandler.GestureEvent gestureEvent, int n, int n2, PMVMatrix4f pMVMatrix4f, Recti recti, Vec3f vec3f) {
        if (this.isInteractive() && this.isResizable() && gestureEvent instanceof PinchToZoomGesture.ZoomEvent) {
            PinchToZoomGesture.ZoomEvent zoomEvent = (PinchToZoomGesture.ZoomEvent)gestureEvent;
            float f = zoomEvent.getDelta() * zoomEvent.getScale();
            int n3 = n + Math.round(f);
            Vec3f vec3f2 = this.winToShapeCoord(pMVMatrix4f, recti, n3, n2, new Vec3f());
            if (null == vec3f2) {
                return;
            }
            float f2 = vec3f2.x();
            float f3 = vec3f2.y();
            float f4 = this.scale.x() + f2 / this.box.getWidth();
            float f5 = this.scale.y() + f3 / this.box.getHeight();
            if (0.005f <= f4 && 0.005f <= f5) {
                this.setScale(f4, f5, this.scale.z());
            }
            return;
        }
        EventInfo eventInfo = new EventInfo(n, n2, this, vec3f);
        gestureEvent.setAttachment(eventInfo);
        this.dispatchGestureEvent(gestureEvent);
    }

    final boolean dispatchGestureEvent(GestureHandler.GestureEvent gestureEvent) {
        for (int i = 0; !gestureEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).gestureDetected(gestureEvent);
        }
        return gestureEvent.isConsumed();
    }

    final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        short s = keyEvent.getEventType();
        block4: for (int i = 0; !keyEvent.isConsumed() && i < this.keyListeners.size(); ++i) {
            KeyListener keyListener = this.keyListeners.get(i);
            switch (s) {
                case 300: {
                    keyListener.keyPressed(keyEvent);
                    continue block4;
                }
                case 301: {
                    keyListener.keyReleased(keyEvent);
                    continue block4;
                }
                default: {
                    throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
                }
            }
        }
        return keyEvent.isConsumed();
    }

    protected abstract void validateImpl(GL2ES2 var1, GLProfile var2);

    protected abstract void drawImpl0(GL2ES2 var1, RegionRenderer var2, Vec4f var3);

    protected abstract void drawToSelectImpl0(GL2ES2 var1, RegionRenderer var2);

    protected abstract void clearImpl0(GL2ES2 var1, RegionRenderer var2);

    protected abstract void destroyImpl0(GL2ES2 var1, RegionRenderer var2);

    public abstract boolean hasColorChannel();

    private static int compareAsc0(float f, float f2) {
        if (FloatUtil.isEqual2(f, f2)) {
            return 0;
        }
        if (f < f2) {
            return -1;
        }
        return 1;
    }

    private static int compareAsc1(float f, float f2) {
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        return 0;
    }

    private static int compareDesc0(float f, float f2) {
        if (FloatUtil.isEqual2(f, f2)) {
            return 0;
        }
        if (f < f2) {
            return 1;
        }
        return -1;
    }

    private static int compareDesc1(float f, float f2) {
        if (f < f2) {
            return 1;
        }
        if (f > f2) {
            return -1;
        }
        return 0;
    }

    public static interface DrawListener {
        public boolean run(Shape var1, GL2ES2 var2, RegionRenderer var3);
    }

    public static interface PointerListener {
        public void run(Shape var1, Vec3f var2, MouseEvent var3);
    }

    public static interface MoveListener {
        public void run(Shape var1, Vec3f var2, Vec3f var3, MouseEvent var4);
    }

    public static interface Listener {
        public void run(Shape var1);
    }

    public static class ForwardMouseListener
    implements MouseGestureListener {
        public final Shape receiver;

        public ForwardMouseListener(Shape shape) {
            this.receiver = shape;
        }

        private void dispatch(MouseEvent mouseEvent) {
            if (this.receiver.isInteractive()) {
                this.receiver.dispatchMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            if (this.receiver.isInteractive()) {
                this.receiver.dispatchGestureEvent(gestureEvent);
            }
        }
    }

    public static interface MouseGestureListener
    extends MouseListener,
    GestureHandler.GestureListener {
    }

    public static class ForwardKeyListener
    implements KeyListener {
        public final Shape receiver;

        public ForwardKeyListener(Shape shape) {
            this.receiver = shape;
        }

        private void dispatch(KeyEvent keyEvent) {
            if (this.receiver.isInteractive()) {
                this.receiver.dispatchKeyEvent(keyEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.dispatch(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.dispatch(keyEvent);
        }
    }

    public static class EventInfo {
        public final Shape shape;
        public final Vec3f objPos;
        public final int[] winPos;
        public final Vec2f objDrag = new Vec2f();
        public final int[] winDrag = new int[]{0, 0};

        EventInfo(int n, int n2, Shape shape, Vec3f vec3f) {
            this.winPos = new int[]{n, n2};
            this.shape = shape;
            this.objPos = vec3f;
        }

        public String toString() {
            return "EventInfo[winPos [" + this.winPos[0] + ", " + this.winPos[1] + "], objPos [" + this.objPos + "], " + this.shape + "]";
        }
    }

    public static abstract class MouseGestureAdapter
    extends MouseAdapter
    implements MouseGestureListener {
        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
        }
    }

    public static interface Visitor2 {
        public boolean visit(Shape var1, PMVMatrix4f var2);
    }

    public static interface Visitor1 {
        public boolean visit(Shape var1);
    }
}

