/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.table.ObjectSelectedListener;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsDataFrame;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsTableModelFactory;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.sarif.SarifTaintGraphRunHandler;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sarif.SarifService;

public class TaintLabelsTableProvider
extends ComponentProviderAdapter {
    private TaintPlugin plugin;
    private Program program;
    private JComponent mainPanel;
    private GhidraTable gtable;
    public GhidraFilterTable<Map<String, Object>> filterTable;
    private TaintLabelsTableModelFactory.TaintLabelsTableModel model;
    private static String clearTaintTagsIconString = "icon.clear";
    private static Icon clearTaintTagsIcon = new GIcon(clearTaintTagsIconString);
    private static String executeTaintQueryIconString = "icon.graph.default.display.program.graph";
    private static Icon executeTaintQueryIcon = new GIcon(executeTaintQueryIconString);

    public TaintLabelsTableProvider(String description, TaintPlugin plugin, TaintLabelsDataFrame df) {
        super(plugin.getTool(), description, plugin.getName());
        this.plugin = plugin;
        this.program = plugin.getCurrentProgram();
        TaintLabelsTableModelFactory factory = new TaintLabelsTableModelFactory(df.getColumnHeaders());
        this.model = factory.createModel("Source-Sink Query Results Table", plugin, this.program, df, this);
        this.mainPanel = this.buildPanel();
        this.filterTable.addSelectionListener((ObjectSelectedListener)df);
        this.filterTable.getTable().getSelectionModel().addListSelectionListener(e -> {
            Msg.info((Object)((Object)this), (Object)"list selection listener triggered.");
            plugin.getTool().contextChanged((ComponentProvider)this);
        });
        this.createActions();
    }

    private JComponent buildPanel() {
        this.filterTable = new GhidraFilterTable((RowObjectTableModel)this.model);
        GhidraTable table = this.filterTable.getTable();
        table.installNavigation((ServiceProvider)this.plugin.getTool());
        table.setName("DataTable");
        this.model.addTableModelListener(e -> {
            Msg.info((Object)((Object)this), (Object)"TableModelListener fired");
            int rowCount = this.model.getRowCount();
            int unfilteredCount = this.model.getUnfilteredRowCount();
            this.model.getDataFrame().dumpTableToDebug();
            this.setSubTitle(rowCount + " items" + (String)(rowCount != unfilteredCount ? " (of " + unfilteredCount + ")" : ""));
            this.filterTable.repaint();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.filterTable, "Center");
        return panel;
    }

    public void reloadModel() {
        this.model.reload();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public GhidraTable getTable() {
        return this.gtable;
    }

    public void createActions() {
        MakeProgramSelectionAction selectionAction = new MakeProgramSelectionAction((Plugin)this.plugin, this.filterTable.getTable());
        DockingAction clearTaintMarksAction = new DockingAction("Clear All Taint Marks", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TaintLabelsTableProvider.this.plugin.getTaintState().clearMarkers();
                TaintLabelsTableProvider.this.plugin.clearIcons();
                TaintLabelsTableProvider.this.model.getDataFrame().loadData();
                TaintLabelsTableProvider.this.model.reload();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return TaintLabelsTableProvider.this.plugin.getTaintState().hasMarks();
            }
        };
        clearTaintMarksAction.setToolBarData(new ToolBarData(clearTaintTagsIcon));
        DockingAction queryAction = new DockingAction("Execute Source-Sink Query", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                Msg.info((Object)((Object)this), (Object)"Execute Source-Sink Query from Taint Labels Table");
                final Program currentProgram = TaintLabelsTableProvider.this.plugin.getCurrentProgram();
                if (currentProgram == null) {
                    return;
                }
                final TaintState state = TaintLabelsTableProvider.this.plugin.getTaintState();
                Task queryTask = new Task("Source-Sink Query Task", true, false, false, true){

                    public void run(TaskMonitor monitor) {
                        monitor.initialize((long)TaintLabelsTableProvider.this.program.getFunctionManager().getFunctionCount());
                        boolean successful = state.queryIndex(currentProgram, TaintLabelsTableProvider.this.tool, TaintState.QueryType.SRCSINK);
                        if (!successful) {
                            state.cancel();
                        }
                        monitor.clearCancelled();
                    }
                };
                TaintLabelsTableProvider.this.tool.execute(queryTask);
                if (!state.isCancelled()) {
                    SarifService sarifService = TaintLabelsTableProvider.this.plugin.getSarifService();
                    sarifService.getController().setDefaultGraphHander(SarifTaintGraphRunHandler.class);
                    sarifService.showSarif("query", state.getData());
                    TaintLabelsTableProvider.this.plugin.consoleMessage("executing query...");
                    TaintProvider provider = TaintLabelsTableProvider.this.plugin.getProvider();
                    provider.setTaint();
                    TaintLabelsTableProvider.this.plugin.consoleMessage("query complete");
                } else {
                    TaintLabelsTableProvider.this.plugin.consoleMessage("Source-Sink query was cancelled.");
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        queryAction.setToolBarData(new ToolBarData(executeTaintQueryIcon));
        this.addLocalAction((DockingActionIf)selectionAction);
        this.addLocalAction((DockingActionIf)clearTaintMarksAction);
        this.addLocalAction((DockingActionIf)queryAction);
    }
}

