/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.ghidra;

public class GConv {
    public static final int BYTE_MASK = 255;
    public static final int SHORT_MASK = 65535;
    public static final long INT_MASK = 0xFFFFFFFFL;

    private GConv() {
    }

    public static short byteToShort(byte b) {
        return (short)(b & 0xFF);
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static long byteToLong(byte b) {
        return GConv.intToLong(b & 0xFF);
    }

    public static int shortToInt(short s) {
        return s & 0xFFFF;
    }

    public static long shortToLong(short s) {
        return GConv.intToLong(s & 0xFFFF);
    }

    public static long intToLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static String toString(byte[] array) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : array) {
            buffer.append((char)b);
        }
        return buffer.toString();
    }

    public static String toHexString(byte b) {
        return GConv.zeropad(Integer.toHexString(GConv.byteToInt(b)), 2);
    }

    public static String toHexString(short s) {
        return GConv.zeropad(Integer.toHexString(GConv.shortToInt(s)), 4);
    }

    public static String toHexString(int i) {
        return GConv.zeropad(Integer.toHexString(i), 8);
    }

    public static String toHexString(long l) {
        return GConv.zeropad(Long.toHexString(l), 16);
    }

    public static String zeropad(String s, int len) {
        if (s == null) {
            s = "";
        }
        StringBuffer buffer = new StringBuffer(s);
        int zerosNeeded = len - s.length();
        for (int i = 0; i < zerosNeeded; ++i) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }
}

