/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import docking.ActionContext;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.visualization.DefaultDisplayGraphIcons;
import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class DefaultGraphDisplayComponentProvider
extends ComponentProviderAdapter {
    static final String WINDOW_GROUP = "ProgramGraph";
    private static final String WINDOW_MENU_GROUP_NAME = "Graph";
    private DefaultGraphDisplay display;

    DefaultGraphDisplayComponentProvider(DefaultGraphDisplay display, PluginTool pluginTool) {
        super(pluginTool, WINDOW_MENU_GROUP_NAME, "DefaultGraphDisplay");
        this.display = display;
        this.setHelpLocation(new HelpLocation("GraphServices", "Default_Graph_Display"));
        this.setIcon(DefaultDisplayGraphIcons.PROGRAM_GRAPH_ICON);
        this.setTransient();
        this.setWindowGroup(WINDOW_GROUP);
    }

    public String getWindowSubMenuName() {
        return WINDOW_MENU_GROUP_NAME;
    }

    public JComponent getComponent() {
        return this.display.getComponent();
    }

    public void closeComponent() {
        if (this.display != null) {
            super.closeComponent();
            DefaultGraphDisplay closingDisplay = this.display;
            this.display = null;
            closingDisplay.close();
            this.removeAllLocalActions();
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        return this.display.getActionContext(event);
    }

    public void removeAllLocalActions() {
        super.removeAllLocalActions();
    }
}

