/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.userdump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugInfo
implements StructConverter {
    public static final String NAME = "DEBUG_EVENT";
    private int eventCode;
    private int processId;
    private int threadId;
    private int exceptionCode;
    private int exceptionFlags;
    private long exceptionRecord;
    private long exceptionAddress;
    private int numberOfParameters;
    private long[] parameters = new long[16];
    private long index;
    private int psz;

    DebugInfo(DumpFileReader reader, long index) throws IOException {
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse(reader);
    }

    private void parse(DumpFileReader reader) throws IOException {
        reader.setPointerIndex(this.index);
        this.setEventCode(reader.readNextInt());
        this.setProcessId(reader.readNextInt());
        this.setThreadId(reader.readNextInt());
        reader.readNextInt();
        this.setExceptionCode(reader.readNextInt());
        this.setExceptionFlags(reader.readNextInt());
        this.setExceptionRecord(reader.readNextPointer());
        this.setExceptionAddress(reader.readNextPointer());
        this.numberOfParameters = reader.readNextInt();
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.parameters[i] = reader.readNextPointer();
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(StructConverter.DWORD, 4, "EventCode", null);
        struct.add(StructConverter.DWORD, 4, "ProcessId", null);
        struct.add(StructConverter.DWORD, 4, "ThreadId", null);
        struct.add(StructConverter.DWORD, 4, "_alignment", null);
        struct.add(StructConverter.DWORD, 4, "ExceptionCode", null);
        struct.add(StructConverter.DWORD, 4, "ExceptionFlags", null);
        struct.add(StructConverter.POINTER, this.psz, "pExceptionRecord", null);
        struct.add(StructConverter.POINTER, this.psz, "ExceptionAddress", null);
        struct.add(StructConverter.DWORD, 4, "NumberOfParameters", null);
        for (int i = 0; i < this.numberOfParameters; ++i) {
            struct.add(StructConverter.POINTER, this.psz, "Param_" + i, null);
        }
        struct.setCategoryPath(new CategoryPath("/UDMP"));
        return struct;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public long getExceptionAddress() {
        return this.exceptionAddress;
    }

    public void setExceptionAddress(long exceptionAddress) {
        this.exceptionAddress = exceptionAddress;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public int getExceptionFlags() {
        return this.exceptionFlags;
    }

    public void setExceptionFlags(int exceptionFlags) {
        this.exceptionFlags = exceptionFlags;
    }

    public long getExceptionRecord() {
        return this.exceptionRecord;
    }

    public void setExceptionRecord(long exceptionRecord) {
        this.exceptionRecord = exceptionRecord;
    }
}

