/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.unixaout.UnixAoutRelocation;
import ghidra.app.util.bin.format.unixaout.UnixAoutSymbolTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UnixAoutRelocationTable
implements Iterable<UnixAoutRelocation>,
StructConverter {
    private static final int ENTRY_SIZE = 8;
    private final long fileSize;
    private final List<UnixAoutRelocation> relocations;
    private final UnixAoutSymbolTable symtab;

    public UnixAoutRelocationTable(BinaryReader reader, long fileOffset, long fileSize, UnixAoutSymbolTable symtab) throws IOException {
        this.fileSize = fileSize;
        this.relocations = new ArrayList<UnixAoutRelocation>();
        this.symtab = symtab;
        reader.setPointerIndex(fileOffset);
        while (reader.getPointerIndex() < fileOffset + fileSize) {
            long address = reader.readNextUnsignedInt();
            long flags = reader.readNextUnsignedInt();
            UnixAoutRelocation relocation = new UnixAoutRelocation(address, flags, reader.isBigEndian());
            this.relocations.add(relocation);
        }
    }

    @Override
    public Iterator<UnixAoutRelocation> iterator() {
        return this.relocations.iterator();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String dtName = "relocation_info";
        StructureDataType struct = new StructureDataType(new CategoryPath("/AOUT"), dtName, 0);
        struct.setPackingEnabled(true);
        try {
            struct.add(DWORD, "r_address", null);
            struct.addBitField(DWORD, 24, "r_symbolnum", null);
            struct.addBitField(BYTE, 1, "r_pcrel", null);
            struct.addBitField(BYTE, 2, "r_length", null);
            struct.addBitField(BYTE, 1, "r_extern", null);
            struct.addBitField(BYTE, 1, "r_baserel", null);
            struct.addBitField(BYTE, 1, "r_jmptable", null);
            struct.addBitField(BYTE, 1, "r_relative", null);
            struct.addBitField(BYTE, 1, "r_copy", null);
        }
        catch (InvalidDataTypeException e) {
            throw new RuntimeException(e);
        }
        return new ArrayDataType((DataType)struct, (int)(this.fileSize / 8L), 8);
    }

    public void markup(Program program, MemoryBlock block) throws CodeUnitInsertionException, DuplicateNameException, IOException {
        Listing listing = program.getListing();
        Data array = listing.createData(block.getStart(), this.toDataType());
        int idx = 0;
        for (UnixAoutRelocation relocation : this) {
            String name = relocation.getSymbolName(this.symtab);
            if (!StringUtils.isBlank((CharSequence)name)) {
                Data structData = array.getComponent(idx);
                structData.setComment(CommentType.EOL, name);
            }
            ++idx;
        }
    }
}

