/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class OpenedDomainFile<T extends DomainObject>
implements AutoCloseable {
    public final T content;

    public static <T extends DomainObject> OpenedDomainFile<T> open(Class<T> contentType, DomainFile file, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        return new OpenedDomainFile<T>(contentType, file, okToUpgrade, okToRecover, monitor);
    }

    public static <T extends DomainObject> OpenedDomainFile<T> open(Class<T> contentType, DomainFile file, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        return new OpenedDomainFile<T>(contentType, file, false, false, monitor);
    }

    public OpenedDomainFile(Class<T> contentType, DomainFile file, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (!contentType.isAssignableFrom(file.getDomainObjectClass())) {
            throw new ClassCastException("file " + String.valueOf(file) + " does not contain " + String.valueOf(contentType) + ". got " + String.valueOf(file.getDomainObjectClass()) + " instead.");
        }
        this.content = (DomainObject)contentType.cast(file.getDomainObject((Object)this, okToUpgrade, okToRecover, monitor));
    }

    @Override
    public void close() {
        if (this.content != null) {
            this.content.release((Object)this);
        }
    }
}

